<?php

namespace Usoko\SIGBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * UtilizadorRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class UtilizadorRepository extends EntityRepository {

    public function loadUserByUsername($username) {
        $q = $this
                ->createQueryBuilder('u')
                ->select('u')
                ->where('u.username = :username')
                ->setParameter('username', $username)
                ->getQuery();
        try {
            // The Query::getSingleResult() method throws an exception
            // if there is no record matching the criteria.
            $user = $q->getSingleResult();
        } catch (NoResultException $e) {
            $message = sprintf('Unable to find an active admin UsokoSIGBundle:User object identified by "%s".', $username);
            throw new UsernameNotFoundException($message, 0, $e);
        }
        return $user;
    }

    public function refreshUser(\Symfony\Component\Security\Core\User\UserInterface $user) {

        $class = get_class($user);
        if (!$this->supportsClass($class)) {
            throw new UnsupportedUserException(
            sprintf('Instances of "%s" are not supported.', $class));
        }
        return $this->find($user->getId());
    }

    public function supportsClass($class) {

        return $this->getEntityName() === $class || is_subclass_of($class, $this->getEntityName());
    }

}
