<?php

namespace Usoko\SIGBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * UtilizadorRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class PagamentoRepository extends EntityRepository {

    public function tipoPagamento($tipo, $estado) {

        $query = $this->getEntityManager()
                ->createQuery(
                        ' SELECT p '
                        . 'FROM UsokoSIGBundle:Pagamento p '
                        . 'JOIN p.tipopagamento tp '
                        . 'WHERE tp.tipo = :tipo AND p.estado = :estado '
                        . 'ORDER BY p.dataActual DESC '
                )->setParameter('tipo', $tipo)
                ->setParameter('estado', $estado);

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function hasfPaid($entity, $em) {

//        $associado = $entity->getAssociado()->getId();
//        $mesAno = $entity->getMesAno();
//
//        return $em->getRepository('UsokoSIGBundle:Pagamento')
//                        ->createQueryBuilder('p')
//                        ->select('p')
//                        ->leftJoin('p.associado', 'a')->leftJoin('p.tipopagamento', 't')
//                        ->where('a.id = :associado AND t.tipo = :tipo AND p.estado = :estado AND p.mesAno = :mesano')
//                        ->setParameter('associado', $associado)
//                        ->setParameter('tipo', 'Q')
//                        ->setParameter('estado', 'L')
//                        ->setParameter('mesano', $mesAno)
//                        ->getQuery()->getResult();
//
//
//
//        $query = $this->getEntityManager()
//                        ->createQuery(
//                                ' SELECT pca '
//                                . 'FROM UsokoSIGBundle:Pagamento p '
//                                . 'JOIN p.tipopagamento tp '
//                                . 'WHERE tp.tipo = :tipo'
//                                //. 'ORDER BY  '
//                        )->setParameter('tipo', $tipo);
//
//        try {
//            return $query->getResult();
//        } catch (\Doctrine\ORM\NoResultException $e) {
//            return null;
//        }
    }
    
    public function creditoPagamentos($reg) {
     $query = $this->getEntityManager()
                ->createQuery(
                        ' SELECT CR, CR.id as id, sum(P.valor) as valor_pago, CR.valor as valor_total'
                        . ' FROM UsokoSIGBundle:CreditoResposta CR, UsokoSIGBundle:Pagamento P, UsokoSIGBundle:Tipopagamento TP '
                        . " WHERE P.tipopagamento = TP.id and CR.resposta='AP' and TP.tipo='C' and CR.id = P.registo AND P.registo=:reg "
                        . " GROUP by P.associado "
                        . "HAVING sum(P.valor)>=CR.valor"
                      )->setParameter('reg', $reg);

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
                
    }
	
	 /*public function creditoPagamentos($reg) {
        $query = $this->getEntityManager()
                        ->createQuery(
                                ' SELECT CR, CR.id as id, sum(P.valor) as valor_pago, CR.valor as valor_total'
                                . ' FROM UsokoSIGBundle:CreditoResposta CR, UsokoSIGBundle:Pagamento P, UsokoSIGBundle:Tipopagamento TP '
                                . " WHERE P.tipopagamento = TP.id and CR.resposta='AP' and TP.tipo='C' and CR.id = P.registo AND P.registo=:reg "
                                . " GROUP by P.associado "
                                . "HAVING sum(P.valor)>=CR.valor"
                        )->setParameter('reg', $reg);

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }*/

    public function registoNovosAssociadosExcel($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM UsokoSIGBundle:Pagamento PA 
			       JOIN PA.tipopagamento TP JOIN PA.associado ASS 
			       WHERE TP.tipo IN('Q') AND PA.dataActual BETWEEN :data1 AND :data2 
                               GROUP BY PA.associado,PA.mesAno 
			       ORDER BY PA.associado,PA.mesAno,PA.tipopagamento ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function associadosExistentesExcel($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT ASS.id as CODIGOASSOCIADO, 
                               ASS.nMecanografico as MECANOGR, 
                               PE.nome as NOMEDELE,
                               PE.dataNascimento as DATANASCIMENTO,
                               PE.genero as GENERO,
                               ASS.dataAdmissao as DATAADMISSAO,
                               CA.cargo as CARGO,
                               ORG.nome as ORGAO,
                               ASS.saldoliquido as SALARIOLIQUIDO,
                               ASS.planopensao AS PLANOPENSAO
                               FROM UsokoSIGBundle:Associado ASS 
							   JOIN ASS.pessoa PE JOIN ASS.cargo CA
                               JOIN ASS.orgao ORG
							   WHERE ASS.dataAdmissao BETWEEN :data1 AND :data2 
                               ORDER BY ASS.id ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function pagamentosExtra($associado) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT SUM(PA.valor) as TOTAL 
                               FROM UsokoSIGBundle:Pagamento PA 
			       JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                               WHERE TP.tipo NOT IN('J','Q','C','PP') 
                               AND PA.associado = :assoc  
                               GROUP BY PA.associado 
			       ")
                ->setParameters(array('assoc' => $associado));

        try {
            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function QuotaAssociado($associado) {

        $query = $this->getEntityManager()
                        ->createQuery("SELECT PA.valor as TOTAL FROM 
                               UsokoSIGBundle:Pagamento PA 
		               JOIN PA.tipopagamento TP JOIN PA.associado ASS 
			       WHERE TP.tipo IN('Q') AND PA.associado = :assoc  
                               ")
                        ->setParameters(array('assoc' => $associado))->setMaxResults(1);

        try {
            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function registoQuotas($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT ASS.id as CODIGOASSOCIADO, 
				 ASS.nMecanografico as MECANOGR, 
				 PE.nome as NOMEDELE,
				 ASS.dataAdmissao as DATAADMISSAO,
				 ASS.status as STATUS,
				 CA.cargo as CARGO,
				 ORG.nome as ORGAO,
				 ASS.saldoliquido as SALARIOLIQUIDO
				 FROM UsokoSIGBundle:Associado ASS 
				 JOIN ASS.pessoa PE JOIN ASS.cargo CA
				 JOIN ASS.orgao ORG
				 WHERE ASS.dataAdmissao BETWEEN :data1 AND :data2 
				 ORDER BY ASS.id  
                                   ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function todasQuotaAssociado($data1, $data2) {
        //jdjdjjddhjdhjhd
        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM UsokoSIGBundle:Pagamento PA 
		                       JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                                       JOIN ASS.pessoa PE
			               WHERE TP.tipo = :tipos 
                                       AND PA.dataActual BETWEEN  :data1 AND :data2 
                                       ORDER BY PE.nome, PA.mesAno ASC ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2, 'tipos' => 'Q'));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function controloQuotas($data1, $data2) {
        //jdjdjjddhjdhjhd
        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM UsokoSIGBundle:Pagamento PA 
		                       JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                                       JOIN ASS.pessoa PE
			               WHERE TP.tipo = :tipos 
                                       AND PA.dataActual BETWEEN :data1 AND :data2 
                                       ORDER BY PE.nome, PA.mesAno ASC ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2, 'tipos' => 'Q'));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function registoSubsidiosExcel($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT CO FROM UsokoSIGBundle:Comparticipacao CO 
		                       JOIN CO.associado ASS 
			               WHERE CO.dataActual BETWEEN :data1 AND :data2  
                                       ORDER BY CO.associado ASC
                                       ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    //listaVencimentoPlano

    public function listaVencimentoPlano($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT PPD FROM UsokoSIGBundle:PpDesvinculacao PPD
							   JOIN PPD.planoPensao PP JOIN PP.associado ASS 
							   WHERE PP.data BETWEEN :data1 AND :data2  
                               ORDER BY PP.associado ASC
                                       ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function listaParticipantesReformados($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT ASS FROM UsokoSIGBundle:Associado ASS 
		                       WHERE ASS.dataAdmissao BETWEEN :data1 AND :data2
                                       AND ASS.status = :stat
                                       ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2, 'stat' => 'R'));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function capitalAcumulado($associado) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT SUM(PA.valor) FROM UsokoSIGBundle:Pagamento PA
                                       JOIN PA.associado ASS
                                       JOIN PA.tipopagamento TP
                                       WHERE ASS.id = :assoc
                                       AND TP.tipo IN ('J','Q','PP')
                                       ")
                ->setParameters(array('assoc' => $associado));

        try {
            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function numeroDeBeneficiosAssociado($associado) {

        $query = $this->getEntityManager()
                        ->createQuery("SELECT COUNT(CO.id) FROM UsokoSIGBundle:Comparticipacao CO 
		                       JOIN CO.associado ASS 
			               WHERE ASS.id = :assoc 
                                       ")->setParameters(array('assoc' => $associado));

        try {
            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }
    
        public function numeroDeBeneficiosUsufruidoAssociado($associado) {

        $query = $this->getEntityManager()
                        ->createQuery("SELECT COUNT(BP.id) FROM UsokoSIGBundle:BeneficioPedido BP 
		                       JOIN BP.planoPensao PP
                                       JOIN PP.associado ASS 
			               WHERE ASS.id = :assoc AND BP.estado = :estat 
                                       ")->setParameters(array('assoc' => $associado,'estat'=>'A'));

        try {
            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function registoBeneficioPago($data1, $data2, $tipo) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM 
                               UsokoSIGBundle:Pagamento PA 
		               JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                               JOIN ASS.pessoa PE WHERE TP.tipo = :tipos AND 
                               PA.dataActual BETWEEN :data1 AND :data2 
                               ORDER BY PE.nome, PA.mesAno ASC
                               ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2, 'tipos' => $tipo));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function registoContribuicoes($data1, $data2, $tipo, $estado) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM 
                               UsokoSIGBundle:Pagamento PA 
		               JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                               JOIN ASS.pessoa PE WHERE TP.tipo = :tipos 
                               AND PA.estado = :estados
                               AND PA.dataActual BETWEEN :data1 AND :data2 
                               ORDER BY PE.nome, PA.mesAno ASC
                               ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2,
            'tipos' => $tipo, 'estados' => $estado));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function registoDeAmortizacoes($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT CR FROM 
                               UsokoSIGBundle:CreditoResposta CR
                               JOIN CR.creditoPedido CP JOIN CP.tipoCredito TC 
                               JOIN CP.associado ASS JOIN ASS.pessoa PE
                               WHERE CR.resposta = :respostas 
                               AND CP.dataActual BETWEEN :data1 AND :data2
                               AND ASS.id IN( SELECT ASSA.id FROM 
                                              UsokoSIGBundle:Pagamento PAA
                                              JOIN PAA.tipopagamento TPA
                                              JOIN PAA.associado ASSA
                                              WHERE TPA.tipo = :tipopag
                                              ) 
                               ORDER BY PE.nome
                               ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2,
            'respostas' => 'A', 'tipopag' => 'C'));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function pagamentosAssociado($data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT PA FROM 
                               UsokoSIGBundle:Pagamento PA 
		               JOIN PA.tipopagamento TP JOIN PA.associado ASS 
                               JOIN ASS.pessoa PE WHERE  
                               PA.dataActual BETWEEN :data1 AND :data2 
                               ORDER BY PE.nome,PA.tipopagamento, PA.mesAno ASC
                               ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }

    public function subsidiosAssociadoPeriodo($associado, $data1, $data2) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT CO FROM UsokoSIGBundle:Comparticipacao CO 
		                       JOIN CO.associado ASS 
			               WHERE  CO.associado = :assoq
                                       AND CO.dataActual BETWEEN :data1 AND :data2  
                                       ORDER BY CO.dataActual,CO.valor ASC
                                       ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2, 'assoq' => $associado));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }
    
    public function registoDeAmortizacoesIndividual($data1, $data2,$associado) {

        $query = $this->getEntityManager()
                ->createQuery("SELECT CR FROM 
                               UsokoSIGBundle:CreditoResposta CR
                               JOIN CR.creditoPedido CP JOIN CP.tipoCredito TC 
                               JOIN CP.associado ASS JOIN ASS.pessoa PE
                               WHERE CR.resposta = :respostas 
                               AND CP.dataActual BETWEEN :data1 AND :data2
                               AND ASS.id IN( SELECT ASSA.id FROM 
                                              UsokoSIGBundle:Pagamento PAA
                                              JOIN PAA.tipopagamento TPA
                                              JOIN PAA.associado ASSA
                                              WHERE TPA.tipo = :tipopag
                                              ) 
                               AND ASS.id = :codassoq               
                               ORDER BY PE.nome
                               ")
                ->setParameters(array('data1' => $data1, 'data2' => $data2,
            'respostas' => 'A', 'tipopag' => 'C','codassoq'=>$associado));

        try {
            return $query->getResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }


}
