<?php

namespace Usoko\SIGBundle\Repository;

use Doctrine\ORM\EntityRepository;

/**
 * UtilizadorRepository
 *
 * This class was generated by the Doctrine ORM. Add your own custom
 * repository methods below.
 */
class AssociadoRepository extends EntityRepository {

    //Metodo que retorna otal de associados 
    //Parametro genero opcional  (no caso de não passar devolve todos )
    public function TotalAssociados($genero = null) {
        try {
            if ($genero == null) {
                $query = $this->getEntityManager()
                                ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A  
                               ")->setMaxResults(1);
            } else {
                $query = $this->getEntityManager()
                        ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A JOIN A.pessoa  P
                               WHERE P.genero = :genero 
                               ")
                        ->setParameter("genero", $genero)
                        ->setMaxResults(1);
            }

            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }


public function TotalEstadoCivil($estadoCivil = null) {
        try {
            if ($estadoCivil == null) {
                $query = $this->getEntityManager()
                                ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A  
                               ")->setMaxResults(1);
            } else {
                $query = $this->getEntityManager()
                        ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A JOIN A.pessoa  P
                               WHERE P.estadoCivil = :estadoCivil 
                               ")
                        ->setParameter("estadoCivil", $estadoCivil)
                        ->setMaxResults(1);
            }

            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }
    
    public function TotalStatus($status = null) {
        try {
            if ($status == null) {
                $query = $this->getEntityManager()
                                ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A  
                               ")->setMaxResults(1);
            } else {
                $query = $this->getEntityManager()
                        ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A 
                               WHERE A.status = :status 
                               ")
                        ->setParameter("status", $status)
                        ->setMaxResults(1);
            }

            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }
    
   
            
            
    public function TotalOrgao($orgao = null) {
        try {
            if ($orgao == null) {
                $query = $this->getEntityManager()
                                ->createQuery("SELECT Count(A.id) TOTAL FROM 
                               UsokoSIGBundle:Associado A  
                               ")->setMaxResults(1);
            } else {
                $query = $this->getEntityManager()
                        ->createQuery('SELECT COUNT(A.id) TOTAL  
                            FROM 
                              UsokoSIGBundle:Associado A
                              JOIN  A.orgao O
                               WHERE  O.nome=:orgao 
                               
                               ')
                        ->setParameter("orgao", $orgao)
                        ->setMaxResults(1);
            }

            return $query->getSingleScalarResult();
        } catch (\Doctrine\ORM\NoResultException $e) {
            return null;
        }
    }
    
    
    
//    public function $TotalProvincia($pessoa = null){
//        try {
//            if ($pessoa == null) {
//                $query = $this->getEntityManager()
//                                ->createQuery("SELECT Count(A.id) TOTAL FROM 
//                               UsokoSIGBundle:Associado A  
//                               ")->setMaxResults(1);
//            } else {
//                $query = $this->getEntityManager()
//                        ->createQuery("SELECT Count(A.id) TOTAL FROM 
//                               UsokoSIGBundle:Associado A,Pessoa p,Endereco 
//                               WHERE A.status = :status 
//                               ")
//                        ->setParameter("status", $status)
//                        ->setMaxResults(1);
//            }
//
//            return $query->getSingleScalarResult();
//        } catch (\Doctrine\ORM\NoResultException $e) {
//            return null;
//        }
//    }

}








