<?php

namespace Usoko\SIGBundle\General;

class PDFGeneral {

    const VIEW_TABLE = 'UsokoSIGBundle:PDF:tablePDF.html.twig';
                        //UsokoSIGBundle:PDF:pdf.html.twig
    private $html2pdf;
    private $view;
    private $obj;

    const AUTOR     = 'USOKO_SYSTEM';
    const TITULO    = 'titulo';
    const ENTITIES  = 'entities';
    const COLUNAS   = 'colunas';
    const STYLE     = 'style';

    public function __construct($obj, $orientacao = 'P', $formato = 'A4', $titulo = 'Usoko Relatorio', $assunto = '') {
        $this->html2pdf = new \Html2Pdf_Html2Pdf($orientacao, $formato, 'pt');
        $this->html2pdf->pdf->SetAuthor(PDFGeneral::AUTOR);
        $this->html2pdf->pdf->SetTitle($titulo);
        $this->html2pdf->pdf->SetSubject($assunto);
        $this->html2pdf->pdf->SetDisplayMode("real");
        $this->obj = $obj;
    }

    private function finish($output = 'USOKO.pdf') {
        $this->html2pdf->Output($output);
        $response = new \Symfony\Component\HttpFoundation\Response();
        $response->headers->set('Content-type', 'application/pdf');
        return $response;
    }

    // your view, with your configuration and this method only will transform html to pdf
    public function htmlPARApdf($html) {
        $this->html2pdf->writeHTML($html);
        return $this->finish();
    }

    public function pdfTable($dados) {
        
        $entities = $dados[PDFGeneral::ENTITIES];
        $pdf['entities'] = $this->entitiesForArray($entities);
        $pdf['titulo'] = $dados[PDFGeneral::TITULO];
        $pdf['colunas'] = $this->entityKeys($entities[0]);
        $pdf['style'] = $dados[PDFGeneral::STYLE]; // Colunas que o user deseja apresentar
        
        $html = $this->obj->renderView(PDFGeneral::VIEW_TABLE, array('pdf' => $pdf));
        $this->html2pdf->writeHTML($html);
        return $this->finish();
    }

    public function entitiesForArray($entities) {

        foreach ($entities as $object) {
            $newEntity[] = array_values((array) $object);
        }
        return $newEntity;
    }

    public function entityKeys($object) {
        
        $array = array_keys((array) $object);
        foreach ($array as $value) {
            $data = explode('\\', $value);
            $keys[] = $data[count($data) - 1];
        }
        return $keys;
    }

}

