<?php

namespace Usoko\SIGBundle\General;

class MathGeneral {

    const PERCENTAGEM_MAXIMO = 100;

    /**
     * Calcula o valor percentual de uma parte liquida sobre um valor total
     *
     * @param Total representa o valor total liquido
     * @param Parte representa uma parte liquida do valor total
     *
     * @return Percentagem da parte sobre o todo
     */
    public static function calcPercentagem($total, $parte) {
        return (($parte * MathGeneral::PERCENTAGEM_MAXIMO) / $total);
    }

    /**
     * Calcula a Parte liquida de uma percentagem do total...
     *
     * @param Total representa o valor total liquido
     * @param Percentagem uma percentagem sobre o valor total
     *
     * @return Percentagem da parte sobre o todo
     */
    public static function calcParte($total, $percentagem) {
        return (($total * $percentagem) / MathGeneral::PERCENTAGEM_MAXIMO);
    }
    
    public static function potencia($base, $expoente) {
        return pow($base, $expoente);
    }

}

