<?php

namespace Usoko\SIGBundle\General;

class DataGeneral {

    const DIFERENCE_ALL = 1;
    const DIFERENCE_YEAR = 2;
    const DIFERENCE_MONTH = 3;
    const DIFERENCE_DAY = 4;
    const DDMMYY = 1;

    public static function tempoGeral() {
        return new \DateTime("now");
    }

    public static function tempoParam($param = 'Y') {
        try {
            return date($param);
        } catch (Exception $e) {
            return DataGeneral::tempoGeral();
        }
    }

    public static function dtUSPT($dt) {

        $dt = trim($dt);
        $dta = explode(' ', $dt);
        $hh = isset($dta[1]) ? $dta[1] : "";
        $dta = explode('-', $dta[0]);

        try {
            $dt = $dta[0] . '/' . $dta[1] . '/' . ($dta[2]) . ' ' . $hh;
        } catch (\Exception $e) {
            $dt = $dt . ' ' . $hh;
        }

        return trim($dt);
    }

    public static function diference($start, $end = null, $retorno = null) {

        if ($end == null) {
            $end = DataGeneral::tempoGeral();
        }

        $diff = $end->diff($start);
        $dias = $diff->format('%a');
        $dias = (int) $dias;
        if ($retorno != null) {
            if ($retorno == 'y') {
                if ($dias >= 365)
                    return $diff->format('%y');
                else
                    return 0;
            }elseif ($retorno == 'm') {
                if ($dias > 31) {
                    return $diff->format('%y');
                } else {
                    return 2;
                }
            }
        }

        if ($dias > 365) {
            return $diff->format('%y Ano(s) / %m Mes(es) / %d Dia(s)');
        } elseif ($dias > 31) {
            return $diff->format('%m Mes(es) / %d Dia(s)');
        } elseif ($dias > 0) {
            return $diff->format(' %d Dia(s)');
        } else {
            return $diff->format(' %H Hora(s) %i Minutos ');
        }

        //return "<br />Difference: " . $diff->format('%y ano %m month %d days , %H horas %i minutos %s segundos (total: %a days) ') . "\n";
        //$start = \DateTime::createFromFormat('d. m. Y H:i:s', $start);
        //$end = \DateTime::createFromFormat('d. m. Y H:i:s', $end);
    }

    public static function dataINDatetime($datetime, $mod = 1) {
        $array = (array) $datetime;
        $data = explode(' ', $array['date']);
        if ($mod == DataGeneral::DDMMYY) {
            return isset($data[0]) ? $data[0] : '';
        } elseif ($mod == DataGeneral::DDMMYYHHMMSS) {
            return isset($array['date']) ? $array['date'] : '';
        }
    }
    
        public static function dateForDatabase($date){
        return new \DateTime($date,new \DateTimeZone('Europe/Berlin'));
    }

}
