<?php

namespace Usoko\SIGBundle\General;

use TCPDF;

class AmortizacaoPdf extends TCPDF{

    protected $p;   //valortotal 
    protected $iy;         //percentagem ou taxa de juros
    protected $ny;         //número de anos a amortizar o crédito
    protected $obj;
    protected $mp, $ip, $pp;

    public function __construct($obj, $p = null, $iy = null, $ny = null) {

        $this->p = $p;
        $this->iy = $iy;
        $this->ny = $ny;
        $this->obj = $obj;
        
        parent::__construct($obj);

        $this->AddPage();
        $this->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    }
    
        public function Header() {
        //$em = $this->getDoctrine()->getManager();
        $image_file = K_PATH_IMAGES . 'logo.png';
        $this->Image($image_file, 96, 10, 17, '', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->Ln(15);
		
        //$universidade = $em->getRepository('NeutrinoGACBundle:Pessoajuridica')
        //      ->findOneBy(array('tipojuridica' => VarsGeneral::CONS_PESSOA_JURIDICA_UNIVERSIDADE));

        $texto1 = utf8_encode(utf8_decode('República de Angola'));
        $texto2 = utf8_encode(utf8_decode('Usoko - Associação Mutualista'));
        $texto3 = utf8_encode(utf8_decode('***************************'));
        $this->Ln(5);
        $this->SetFont('times', 'B', 12);
		$this->SetFont('helvetica', 'B', 12);
        $this->Cell(0, 10, $texto1, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(5);
        $this->Cell(0, 10, $texto2, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(5);
        $this->Cell(0, 10, $texto3, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(18);
        $texto = '<b></b>';
        $this->SetFont('times', 9);
		$this->SetFont('helvetica', '', 9);
        $texto = '<u>' . $texto . '</u>';
        $this->writeHTML($texto . $this->Ln(8), TRUE, FALSE, FALSE, FALSE, 'C');
        $this->Ln(5);
    }

    public static function calAmort($p, $iy, $ny) {
        $newbal;
        $im = ($iy / 12) / 100;
        $nm = $ny * 12;
        
      //$mp, $ip, $pp;
        $i;

        $mp = $p * $im * Math . pow(1 + $im, (double) $nm) / (Math . pow(1 + $im, (double) $nm) - 1);
        printHeader();
        //print amortization schedule for all months except the last month
        for ($i = 1; $i < $nm; $i++) {
            $ip = $p * $im; //interest paid
            $pp = $mp - $ip; //princial paid
            $newbal = $p - $pp; //new balance                
            printSch($i, $p, $mp, $ip, $pp, $newbal);
            $p = $newbal;  //update old balance
        }
        //last month
        $pp = $p;
        $ip = $p * $im;
        $mp = $pp + $ip;
        $newbal = 0.0;
        printSch($i, $p, $mp, $ip, $pp, $newbal);
    }
    
    
     public static function printSch($i, $p, $mp, $ip,$pp, $newbal) {
        System.out.format("%-8d%-12.3f%-10.3f%-10.3f%-10.3f%-12.3f\n", $i, $p, $mp, $ip, $pp, $newbal);
    }

    public static function printHeader() {
        $i;
        System.out.println("\nAmortization Schedule for  Borrower");
        for ($i = 0; $i < 62; $i++) {
            System.out.print("-");
        }
        System.out.format("\n%-8s%-12s%-10s%-10s%-10s%-12s", " ", "Old", "Monthly", "Interest", "Principle", "New", "Balance");
        System.out.format("\n%-8s%-12s%-10s%-10s%-10s%-12s\n\n", "Month", "Balance", "Payment", "Paid", "Paid", "Balance");
    }
    
    
     public function Footer() {


        $this->SetY(-15);
        $this->SetFont('helvetica', 'BI', 8);

        $this->Cell(0, 10, 'Usoko - Associação Mutualista', 0, false, 'L', 0, '', 0, false, 'T', 'M');
		$this->Cell(0, 10, "Processado por computador ".date('d/m/Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }

}
