<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class TipopagamentoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('nome', 'text', array('label' => 'Nome'))
                ->add('valor', 'number', array('label' => 'Valor'))
                ->add('base', 'choice', array('label' => 'Base','required' => true ,'choices' => array('P' => 'Percentual', 'L' => 'Valor Liquido')))
                ->add('tipo', 'choice', array('label'=>'Tipo','required' => true ,'choices' => array('Q'=>'Quota','J' =>'Joia' ,'C' =>'Credito')))
                ->add('moeda', null, array('label' => 'Moeda', 'required' => true))
                ->add('frequencia', 'choice', array('label' => 'Frequência', 'choices' => array('U' => 'Única','M' => 'Mensal', 'T' => 'Trimestral'), 'required' => true))
                ->add('descricao', 'textarea', array('label' => 'Descricao', 'required' => false,'attr' => array('maxlength' => 50)))

        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Tipopagamento'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_tipopagamento';
    }

}
