<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class QuotaType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('percentagem', 'number', array('label'=>'Percentagem(%)', 'required'=>true,
                'attr' => array('pattern '=>'[0-9]{1,3}', 
                    'title' => 'Sem letras ou caracteres especiais. Ex: 010',
                    'placeholder' => 'Ex: 002')))
            ->add('frequencia', 'choice', array('label'=>'Frequência','choices'=>array('M'=>'Mensal',
                'T'=>'Trimestral','S'=>'Semestral'), 'required'=>true))
            ->add('tipo', 'choice', array('label'=>'Tipo', 'choices'=>array('B'=>'Beneficio')))
            ->add('moeda', null, array('label'=>'Moeda', 'required'=>true))
            ->add('descricao', 'textarea', array('label'=>'Descricao', 'required'=>false,
                'attr' => array('maxlength' => 50)))
            
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Quota'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_quota';
    }
}
