<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PpAumentoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
//            ->add('planoPensao', null, array('label' => 'Associado', 'required' => true))
   
            ->add('valorPos', 'number', array('label' => 'Novo Valor', 'required' => true,
                'attr' => array(
                    'pattern' => '[1-9]{1}[0-9]{1,}',
                    'title' => 'Digite só valores numéricos.'
                )))
            ->add('anexo', 'file', array('label' => 'Anexo', 'required' => false,
                'attr' => array(
                    'title' => 'Selecione um ficheiro de anexo.'
                )))
            ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false,
                'attr' => array(
                    'maxlength' => 50
                )))
            //->add('data')
//                         ->add('valorAntes', 'number', array('label' => 'Valor Anterior', 'required' => true,
//                'attr' => array(
//                    'pattern' => '[1-9]{1}[0-9]{1,}',
//                    'title' => 'Digite só valores numéricos.'
//                )))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\PpAumento'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_ppaumento';
    }
}
