<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PlanoPensaoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('valor', 'text', array('label' => 'Valor Extra', 'required' => true,
                    'attr' => array('pattern' => '[1-9][0-9.,]{0,}', 'title' => 'Valores numéricos')))
                ->add('moeda', null, array('label' => 'Moeda', 'required' => true))
                ->add('data', 'date', array('widget' => 'single_text', 'label' => 'Data de Adesão', 'required' => true))
                ->add('anexo', 'file', array('label' => 'Anexo', 'required' => false))
                ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false, 'attr' => array('maxlength' => 50)))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\PlanoPensao'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_planopensao';
    }

}
