<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class JustificacaoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nome', 'text', array('label'=>'Nome', 'required'=>true,
                'attr' => array('minlength'=> 2, 'maxlength'=> 50,
                    'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)')))
            ->add('justificacao', 'textarea', array('label'=>'Justificação', 
                'required'=>true, 
                    'attr' => array('minlength'=> 2, 'maxlength'=> 200)))
            //->add('comparticipacaoR', null, array('label'=>'Compartici', 'required'=>true))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Justificacao'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_justificacao';
    }
}
