<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ImportacaoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('data', 'date', array('widget' => 'single_text',
                    'label' => 'Data', 'required' => true))
                //->add('registo')
                ->add('tipo', 'choice', array('label' => 'Tipo de Importação', 'choices' =>
                    array('A' => 'Associado', 'P' => 'Pagamento'), 'required' => true))
                ->add('ficheiro', 'file', array('label' => 'Ficheiro', 'required' => true))
        //->add('utilizador')
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Importacao'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_importacao';
    }

}
