<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class EnderecoType extends AbstractType {

//    protected $em;
//
//    public  function __construct(EntityManager $em) {
//        $this->em = $em;
//    }

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('provincia', null, array('empty_value' => 'Selecione uma Província','label' => 'Província', 'required' => true))
                ->add('municipio', null, array('data_class' => null,'empty_value' => 'Selecione um Municipio ','label' => 'Município', 'required' => true))
                ->add('bairro', 'text', array('label' => 'Bairro', 'required' => false, 'attr' => array('placeholder' => 'Ex. Camama', 'minlength' => 2, 'maxlength' => 45, 'pattern' => '([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)', 'title' => 'Não pode conter caracteres especiais')))
                ->add('rua', 'text', array('label' => 'Rua', 'required' => false, 'attr' => array('placeholder' => 'Ex. Camama', 'minlength' => 1, 'maxlength' => 45, 'pattern' => '([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)', 'title' => 'Não pode conter caracteres especiais')))
                ->add('numero', 'text', array('label' => 'Número', 'required' => false, 'attr' => array('placeholder' => 'Ex. 32', 'minlength' => 1, 'maxlength' => 45, 'pattern' => '([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-Z0-9áéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)', 'title' => 'Não pode conter caracteres especiais')))
                ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false, 'attr' => array('maxlength' => 100)))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Endereco'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_endereco';
    }

}
