<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class CreditoPedidoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('valor', 'number', array('required' => true, 'label' =>'Valor', 'attr' => array('pattern' => '[1-0][0-9.,]{1,}', 'title' => 'Valores numéricos')))
                ->add('urgencia', 'choice', array('label' => 'Urgente', 'choices'=> array('N' => 'Não', 'S' => 'Sim')))
                ->add('tempoAmortizacao', 'choice', array('choices' => array(), 'label' => 'Meses Amortização', 'required' => false))
                ->add('valorMensal', 'number', array('required' => true, 'label' =>'Prestações Mensais', 'attr' => array('pattern' => '[0-9]{1,}', 'title' => 'Valores numéricos', 'readonly' => 'readonly')))
                ->add('anexo', 'file', array('label' => 'Anexo', 'required' => false))
                ->add('descricao', 'textarea', array('label' => 'Observação','required' => false, 'attr' => array('maxlength' => 50)))
                ->add('tipoCredito', null, array('label' => 'Tipo Crédito','required' => false))
                ->add('moeda', null, array('label' => 'Moeda', 'required' => true))
                ->add('urgencia', 'choice', array('label' => 'Urgente', 'choices' => array('N' => 'Não', 'S' => 'Sim')))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\CreditoPedido'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_creditopedido';
    }

}
