<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ComparticipacaoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {

        $associado = $options['associado'];

        $builder
                //->add('associado', null, array('label'=>'Associado', 'required'=>true))
                //->add('estado','choice',array('label'=>'Estado','choices'=>array('A'=>'Activado','D'=>'Desactivado')))
                ->add('urgencia', 'choice', array('label' => 'Urgente', 'choices'
                    => array('N' => 'Não', 'S' => 'Sim')))
                ->add('valor', 'number', array('required' => true, 'label' =>
                    'Valor', 'attr' => array(
                        'pattern' => '[0-9]{1,}', 'title' => 'Valores numéricos')))
                ->add('subsidio', null, array('label' => 'Tipo de Subsídio',
                    'required' => true))
                ->add('moeda', null, array('label' => 'Moeda', 'required' => true))
                ->add('anexo', 'file', array('label' => 'Anexo', 'required' => false))
                ->add('observacao', 'textarea', array('label' => 'Observação',
                    'required' => false, 'attr' => array('maxlength' => 50)))
                // older's job ZP...
                ->add('dependente', null, array('label' => 'Dependente', 'required' => false,
                    'query_builder' => function(\Doctrine\ORM\EntityRepository $er) use ( $associado ) {
                        return $er->createQueryBuilder('D')
                                ->from('UsokoSIGBundle:AssociadoDependentes', 'ad')
                                ->leftJoin('ad.dependentes', 'dependentes')
                                ->leftJoin('ad.associado', 'associado')
                                ->leftJoin('dependentes.pessoa', 'pessoa')
                                ->where('dependentes = D AND associado.id = :id ')
                                ->setParameter('id', $associado)
                                ->orderBy('pessoa.nome', 'ASC');
                    }
                ))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Comparticipacao',
            'associado' => 0
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_comparticipacao';
    }

}
