<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class BeneficioRespostaType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
//                ->add('fpagamento', 'choice', array('required' => true, 'label' => 'Forma de Pagamento', 'choices'
//                    => array('U' => 'Única', 'M' => 'Mensal')))
                ->add('valorTotal', 'number', array('label' => 'Valor Total', 'required' => true,
                    'attr' => array(
                        'pattern' => '[1-9]{1}[0-9]{1,}',
                        'title' => 'Digite só valores numéricos.'
            )))
//                ->add('valorMensal', 'number', array('label' => 'Valor Mensal', 'required' => true,
//                    'attr' => array(
//                        'pattern' => '[1-9]{1}[0-9]{1,}',
//                        'title' => 'Digite só valores numéricos.'
//            )))
                ->add('observacao', 'textarea', array('label' => 'Descrição', 'required' => false,
                    'attr' => array(
                        'maxlength' => 50
            )))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\BeneficioResposta'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_beneficioresposta';
    }

}
