<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class BeneficioPedidoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                //->add('planoPensao', null, array('label' => 'Associado', 'required' => true))
                ->add('tipoBeneficio', null, array('label' => 'Beneficio', 'required' => true))
                ->add('fpagamento', 'choice', array('required' => true, 'label' => 'Forma de Pagamento', 'choices'
                    => array('U' => 'Única', 'M' => 'Mensal')))
                 ->add('valormensal', null, array('label' => 'Valor Mensal', 'required' => false))
                ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false,
                    'attr' => array(
                        'maxlength' => 50
            )))
        //->add('estado')
        //->add('data')
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\BeneficioPedido'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_beneficiopedido';
    }

}
