<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class BancoContaType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('iban', 'text', array('label' => 'IBAN', 'required' => false,
                    'attr' => array(
                        'pattern' => '[A]{1}[O]{1}[0]{1}[6]{1}[0-9]{21,21}', 
                        'title' => 'O IBAN deve seguir o formato: AO06 seguido dos 21 números correspondentes.')))
                ->add('numero', 'text', array('label' => 'Número da Conta',
                    'required' => true,'attr' =>array('placeholder' => 'Ex. 13245',
                        'minlength'=>5, 'maxlength' => 100 
                       )))
                ->add('bancoInstituicao', null, array('label' => 'Instituição Bancária',
                    'required' => true))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\BancoConta'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_bancoconta';
    }

}
