<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class AssociadoTipoinfraccaoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('tipoinfraccao', null, array('label'=>'Tipo de Infração',
                'required' => true))
            ->add('associado', null, array('label'=>'Associado', 
                'required' => true))
            //->add('utilizador')
            ->add('descricao', 'textarea', array('label'=>'Descrição', 
                'required'=>false, 'attr' => array('maxlength' => 50)))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\AssociadoTipoinfraccao'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_associadotipoinfraccao';
    }
}
