<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class AssociadoDependentesType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('percentagem', 'number', array('label' => 'Percentagem(%)',
                    'required' => false,'attr' => array('pattern' => '[0-9]{3}',
                    'title' => 'Sem letras ou caracteres especiais. Ex: 010')))
                ->add('dependentes', new DependenteType(), array('required' => true))
                //->add('associado', null, array('label'=>'Associado', 'required'=>true))
                //->add('associado', 'hidden', array())
                ->add('grauparentesco', null, array('label' => 'Grau Parentesco', 
                    'required' => true))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\AssociadoDependentes'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_associadodependentes';
    }

}
