<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * SimulacaoAssociado
 *
 * @ORM\Table(name="simulacao_associado", indexes={@ORM\Index(name="associado", columns={"associado"}), @ORM\Index(name="simulacao", columns={"simulacao"})})
 * @ORM\Entity
 */
class SimulacaoAssociado
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_simulacao", type="datetime", nullable=false)
     */
    private $dataSimulacao = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="tipo_simulacao", type="string", length=1, nullable=false)
     */
    private $tipoSimulacao;

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="string", length=300, nullable=false)
     */
    private $observacao;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="associado", referencedColumnName="n_Mecanografico")
     * })
     */
    private $associado;

    /**
     * @var \Simulacao
     *
     * @ORM\ManyToOne(targetEntity="Simulacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="simulacao", referencedColumnName="id")
     * })
     */
    private $simulacao;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dataSimulacao
     *
     * @param \DateTime $dataSimulacao
     * @return SimulacaoAssociado
     */
    public function setDataSimulacao($dataSimulacao)
    {
        $this->dataSimulacao = $dataSimulacao;

        return $this;
    }

    /**
     * Get dataSimulacao
     *
     * @return \DateTime 
     */
    public function getDataSimulacao()
    {
        return $this->dataSimulacao;
    }

    /**
     * Set tipoSimulacao
     *
     * @param string $tipoSimulacao
     * @return SimulacaoAssociado
     */
    public function setTipoSimulacao($tipoSimulacao)
    {
        $this->tipoSimulacao = $tipoSimulacao;

        return $this;
    }

    /**
     * Get tipoSimulacao
     *
     * @return string 
     */
    public function getTipoSimulacao()
    {
        return $this->tipoSimulacao;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return SimulacaoAssociado
     */
    public function setObservacao($observacao)
    {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao()
    {
        return $this->observacao;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return SimulacaoAssociado
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set simulacao
     *
     * @param \Usoko\SIGBundle\Entity\Simulacao $simulacao
     * @return SimulacaoAssociado
     */
    public function setSimulacao(\Usoko\SIGBundle\Entity\Simulacao $simulacao = null)
    {
        $this->simulacao = $simulacao;

        return $this;
    }

    /**
     * Get simulacao
     *
     * @return \Usoko\SIGBundle\Entity\Simulacao 
     */
    public function getSimulacao()
    {
        return $this->simulacao;
    }
}
