<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PpDesvinculacaoPercentagem
 *
 * @ORM\Table(name="pp_desvinculacao_percentagem")
 * @ORM\Entity
 */
class PpDesvinculacaoPercentagem
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="percentagem", type="integer", nullable=false)
     */
    private $percentagem;

    /**
     * @var integer
     *
     * @ORM\Column(name="inicio", type="integer", nullable=true)
     */
    private $inicio;

    /**
     * @var integer
     *
     * @ORM\Column(name="fim", type="integer", nullable=true)
     */
    private $fim;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set percentagem
     *
     * @param integer $percentagem
     * @return PpDesvinculacaoPercentagem
     */
    public function setPercentagem($percentagem)
    {
        $this->percentagem = $percentagem;

        return $this;
    }

    /**
     * Get percentagem
     *
     * @return integer 
     */
    public function getPercentagem()
    {
        return $this->percentagem;
    }

    /**
     * Set inicio
     *
     * @param integer $inicio
     * @return PpDesvinculacaoPercentagem
     */
    public function setInicio($inicio)
    {
        $this->inicio = $inicio;

        return $this;
    }

    /**
     * Get inicio
     *
     * @return integer 
     */
    public function getInicio()
    {
        return $this->inicio;
    }

    /**
     * Set fim
     *
     * @param integer $fim
     * @return PpDesvinculacaoPercentagem
     */
    public function setFim($fim)
    {
        $this->fim = $fim;

        return $this;
    }

    /**
     * Get fim
     *
     * @return integer 
     */
    public function getFim()
    {
        return $this->fim;
    }
    
    public function __toString() {
        return "Percentagem: ".$this->getPercentagem()."% Inicio: ".$this->getInicio()." Fim: ".$this->getFim();
    }
}
