<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Pessoa
 *
 * @ORM\Table(name="pessoa")
 * @ORM\Entity
 */
class Pessoa
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=100, nullable=false)
     */
    private $nome;

    /**
     * @var string
     *
     * @ORM\Column(name="genero", type="string", length=1, nullable=false)
     */
    private $genero = 'M';

    /**
     * @var string
     *
     * @ORM\Column(name="estado_civil", type="string", length=2, nullable=true)
     */
    private $estadoCivil = 'S';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_nascimento", type="date", nullable=false)
     */
    private $dataNascimento;

    /**
     * @var string
     *
     * @ORM\Column(name="foto", type="string", length=100, nullable=true)
     */
    private $foto;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=false)
     */
    private $tipo = 'A';

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Contacto", inversedBy="pessoa", cascade={"persist"})
     * @ORM\JoinTable(name="pessoa_contacto",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Contacto", referencedColumnName="id")
     *   }
     * )
     */
    private $contacto;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Documentoidentificacao", inversedBy="pessoa", cascade={"persist"})
     * @ORM\JoinTable(name="pessoa_documento",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="DocumentoIdentificacao", referencedColumnName="id")
     *   }
     * )
     */
    private $documentoidentificacao;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Endereco", inversedBy="pessoa", cascade={"persist"})
     * @ORM\JoinTable(name="pessoa_endereco",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Endereco", referencedColumnName="id")
     *   }
     * )
     */
    private $endereco;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->contacto = new \Doctrine\Common\Collections\ArrayCollection();
        $this->documentoidentificacao = new \Doctrine\Common\Collections\ArrayCollection();
        $this->endereco = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return Pessoa
     */
    public function setNome($nome)
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * Set genero
     *
     * @param string $genero
     * @return Pessoa
     */
    public function setGenero($genero)
    {
        $this->genero = $genero;

        return $this;
    }

    /**
     * Get genero
     *
     * @return string 
     */
    public function getGenero()
    {
        return $this->genero;
    }

    /**
     * Set estadoCivil
     *
     * @param string $estadoCivil
     * @return Pessoa
     */
    public function setEstadoCivil($estadoCivil)
    {
        $this->estadoCivil = $estadoCivil;

        return $this;
    }

    /**
     * Get estadoCivil
     *
     * @return string 
     */
    public function getEstadoCivil()
    {
        return $this->estadoCivil;
    }

    /**
     * Set dataNascimento
     *
     * @param \DateTime $dataNascimento
     * @return Pessoa
     */
    public function setDataNascimento($dataNascimento)
    {
        $this->dataNascimento = $dataNascimento;

        return $this;
    }

    /**
     * Get dataNascimento
     *
     * @return \DateTime 
     */
    public function getDataNascimento()
    {
        return $this->dataNascimento;
    }

    /**
     * Set foto
     *
     * @param string $foto
     * @return Pessoa
     */
    public function setFoto($foto)
    {
        $this->foto = $foto;

        return $this;
    }

    /**
     * Get foto
     *
     * @return string 
     */
    public function getFoto()
    {
        return $this->foto;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Pessoa
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Add contacto
     *
     * @param \Usoko\SIGBundle\Entity\Contacto $contacto
     * @return Pessoa
     */
    public function addContacto(\Usoko\SIGBundle\Entity\Contacto $contacto)
    {
        $this->contacto[] = $contacto;

        return $this;
    }

    /**
     * Remove contacto
     *
     * @param \Usoko\SIGBundle\Entity\Contacto $contacto
     */
    public function removeContacto(\Usoko\SIGBundle\Entity\Contacto $contacto)
    {
        $this->contacto->removeElement($contacto);
    }

    /**
     * Get contacto
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getContacto()
    {
        return $this->contacto;
    }

    /**
     * Add documentoidentificacao
     *
     * @param \Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao
     * @return Pessoa
     */
    public function addDocumentoidentificacao(\Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao)
    {
        $this->documentoidentificacao[] = $documentoidentificacao;

        return $this;
    }

    /**
     * Remove documentoidentificacao
     *
     * @param \Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao
     */
    public function removeDocumentoidentificacao(\Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao)
    {
        $this->documentoidentificacao->removeElement($documentoidentificacao);
    }

    /**
     * Get documentoidentificacao
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getDocumentoidentificacao()
    {
        return $this->documentoidentificacao;
    }

    /**
     * Add endereco
     *
     * @param \Usoko\SIGBundle\Entity\Endereco $endereco
     * @return Pessoa
     */
    public function addEndereco(\Usoko\SIGBundle\Entity\Endereco $endereco)
    {
        $this->endereco[] = $endereco;

        return $this;
    }

    /**
     * Remove endereco
     *
     * @param \Usoko\SIGBundle\Entity\Endereco $endereco
     */
    public function removeEndereco(\Usoko\SIGBundle\Entity\Endereco $endereco)
    {
        $this->endereco->removeElement($endereco);
    }

    /**
     * Get endereco
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getEndereco()
    {
        return $this->endereco;
    }
    
    public function __toString() {
        return $this->getNome();
    }
}
