<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Parametrosimulacao
 *
 * @ORM\Table()
 * @ORM\Entity
 */
class Parametrosimulacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="taxa_rentabilidade", type="decimal")
     */
    private $taxaRentabilidade;

    /**
     * @var string
     *
     * @ORM\Column(name="taxa_rend_salarial", type="decimal")
     */
    private $taxaRendSalarial;

    /**
     * @var string
     *
     * @ORM\Column(name="perc_contribuicao", type="decimal")
     */
    private $percContribuicao;

    /**
     * @var integer
     *
     * @ORM\Column(name="anos_servico", type="integer")
     */
    private $anosServico;

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="string", length=255)
     */
    private $observacao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_criacao", type="datetime")
     */
    private $dataCriacao;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1)
     */
    private $estado;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set taxaRentabilidade
     *
     * @param string $taxaRentabilidade
     * @return Parametrosimulacao
     */
    public function setTaxaRentabilidade($taxaRentabilidade)
    {
        $this->taxaRentabilidade = $taxaRentabilidade;

        return $this;
    }

    /**
     * Get taxaRentabilidade
     *
     * @return string 
     */
    public function getTaxaRentabilidade()
    {
        return $this->taxaRentabilidade;
    }

    /**
     * Set taxaRendSalarial
     *
     * @param string $taxaRendSalarial
     * @return ParametroSimulacao
     */
    public function setTaxaRendSalarial($taxaRendSalarial)
    {
        $this->taxaRendSalarial = $taxaRendSalarial;

        return $this;
    }

    /**
     * Get taxaRendSalarial
     *
     * @return string 
     */
    public function getTaxaRendSalarial()
    {
        return $this->taxaRendSalarial;
    }

    /**
     * Set percContribuicao
     *
     * @param string $percContribuicao
     * @return Parametrosimulacao
     */
    public function setPercContribuicao($percContribuicao)
    {
        $this->percContribuicao = $percContribuicao;

        return $this;
    }

    /**
     * Get percContribuicao
     *
     * @return string 
     */
    public function getPercContribuicao()
    {
        return $this->percContribuicao;
    }

    /**
     * Set anosServico
     *
     * @param integer $anosServico
     * @return Parametrosimulacao
     */
    public function setAnosServico($anosServico)
    {
        $this->anosServico = $anosServico;

        return $this;
    }

    /**
     * Get anosServico
     *
     * @return integer 
     */
    public function getAnosServico()
    {
        return $this->anosServico;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return Parametrosimulacao
     */
    public function setObservacao($observacao)
    {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao()
    {
        return $this->observacao;
    }

    /**
     * Set dataCriacao
     *
     * @param \DateTime $dataCriacao
     * @return Parametrosimulacao
     */
    public function setDataCriacao($dataCriacao)
    {
        $this->dataCriacao = $dataCriacao;

        return $this;
    }

    /**
     * Get dataCriacao
     *
     * @return \DateTime 
     */
    public function getDataCriacao()
    {
        return $this->dataCriacao;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return Parametrosimulacao
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }
    
    public function __toString() {
        return $this->getId();
    }
}
