<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Pagamento
 *
 * @ORM\Table(name="pagamento", indexes={@ORM\Index(name="fk_Associado_has_Quota_Associado1_idx", columns={"Associado"}), @ORM\Index(name="fk_Pagamento_Banco_Conta1_idx", columns={"Banco_Conta"}), @ORM\Index(name="fk_pagamentoTPag", columns={"tipopagamento"})})
 * @ORM\Entity(repositoryClass="Usoko\SIGBundle\Repository\PagamentoRepository")
 */
class Pagamento {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="mes_ano", type="string", length=15, nullable=false)
     */
    private $mesAno;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var float
     *
     * @ORM\Column(name="percentagem", type="float", precision=10, scale=0, nullable=true)
     */
    private $percentagem;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_actual", type="datetime", nullable=true)
     */
    private $dataActual = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=false)
     */
    private $estado;

    /**
     * @var integer
     *
     * @ORM\Column(name="registo", type="integer", nullable=true)
     */
    private $registo;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Tipopagamento
     *
     * @ORM\ManyToOne(targetEntity="Tipopagamento")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="tipopagamento", referencedColumnName="id")
     * })
     */
    private $tipopagamento;

    /**
     * @var \BancoConta
     *
     * @ORM\ManyToOne(targetEntity="BancoConta")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Banco_Conta", referencedColumnName="id")
     * })
     */
    private $bancoConta;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="CreditoPedido", inversedBy="pagamento")
     * @ORM\JoinTable(name="credito_reembolso",
     *   joinColumns={
     *     @ORM\JoinColumn(name="pagamento", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="credito_pedido", referencedColumnName="id")
     *   }
     * )
     */
    private $creditoPedido;

    /**
     * Constructor
     */
    public function __construct() {
        $this->creditoPedido = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set mesAno
     *
     * @param string $mesAno
     * @return Pagamento
     */
    public function setMesAno($mesAno) {
        $this->mesAno = $mesAno;

        return $this;
    }

    /**
     * Get mesAno
     *
     * @return string 
     */
    public function getMesAno() {
        return $this->mesAno;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return Pagamento
     */
    public function setValor($valor) {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor() {
        return $this->valor;
    }

    /**
     * Set percentagem
     *
     * @param float $percentagem
     * @return Pagamento
     */
    public function setPercentagem($percentagem) {
        $this->percentagem = $percentagem;

        return $this;
    }

    /**
     * Get percentagem
     *
     * @return float 
     */
    public function getPercentagem() {
        return $this->percentagem;
    }

    /**
     * Set dataActual
     *
     * @param \DateTime $dataActual
     * @return Pagamento
     */
    public function setDataActual($dataActual) {
        $this->dataActual = $dataActual;

        return $this;
    }

    /**
     * Get dataActual
     *
     * @return \DateTime 
     */
    public function getDataActual() {
        return $this->dataActual;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return Pagamento
     */
    public function setEstado($estado) {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado() {
        return $this->estado;
    }

    /**
     * Set registo
     *
     * @param integer $registo
     * @return Pagamento
     */
    public function setRegisto($registo) {
        $this->registo = $registo;

        return $this;
    }

    /**
     * Get registo
     *
     * @return integer 
     */
    public function getRegisto() {
        return $this->registo;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return Pagamento
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null) {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado() {
        return $this->associado;
    }

    /**
     * Set tipopagamento
     *
     * @param \Usoko\SIGBundle\Entity\Tipopagamento $tipopagamento
     * @return Pagamento
     */
    public function setTipopagamento(\Usoko\SIGBundle\Entity\Tipopagamento $tipopagamento = null) {
        $this->tipopagamento = $tipopagamento;

        return $this;
    }

    /**
     * Get tipopagamento
     *
     * @return \Usoko\SIGBundle\Entity\Tipopagamento 
     */
    public function getTipopagamento() {
        return $this->tipopagamento;
    }

    /**
     * Set bancoConta
     *
     * @param \Usoko\SIGBundle\Entity\BancoConta $bancoConta
     * @return Pagamento
     */
    public function setBancoConta(\Usoko\SIGBundle\Entity\BancoConta $bancoConta = null) {
        $this->bancoConta = $bancoConta;

        return $this;
    }

    /**
     * Get bancoConta
     *
     * @return \Usoko\SIGBundle\Entity\BancoConta 
     */
    public function getBancoConta() {
        return $this->bancoConta;
    }

    /**
     * Add creditoPedido
     *
     * @param \Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido
     * @return Pagamento
     */
    public function addCreditoPedido(\Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido) {
        $this->creditoPedido[] = $creditoPedido;

        return $this;
    }

    /**
     * Remove creditoPedido
     *
     * @param \Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido
     */
    public function removeCreditoPedido(\Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido) {
        $this->creditoPedido->removeElement($creditoPedido);
    }

    /**
     * Get creditoPedido
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getCreditoPedido() {
        return $this->creditoPedido;
    }
    
    public function __toString() {
        return $this->getAssociado()." - ".$this->getMesAno();
    }

}
