<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Operacao
 *
 * @ORM\Table(name="operacao", indexes={@ORM\Index(name="fk_Operacao_Utilizador1_idx", columns={"Utilizador"})})
 * @ORM\Entity
 */
class Operacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="operacao", type="string", length=1, nullable=true)
     */
    private $operacao;

    /**
     * @var string
     *
     * @ORM\Column(name="tabela", type="string", length=45, nullable=true)
     */
    private $tabela;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=true)
     */
    private $data = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="registo", type="string", length=45, nullable=false)
     */
    private $registo;

    /**
     * @var string
     *
     * @ORM\Column(name="dado", type="string", length=200, nullable=false)
     */
    private $dado;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="string", length=100, nullable=true)
     */
    private $descricao;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set operacao
     *
     * @param string $operacao
     * @return Operacao
     */
    public function setOperacao($operacao)
    {
        $this->operacao = $operacao;

        return $this;
    }

    /**
     * Get operacao
     *
     * @return string 
     */
    public function getOperacao()
    {
        return $this->operacao;
    }

    /**
     * Set tabela
     *
     * @param string $tabela
     * @return Operacao
     */
    public function setTabela($tabela)
    {
        $this->tabela = $tabela;

        return $this;
    }

    /**
     * Get tabela
     *
     * @return string 
     */
    public function getTabela()
    {
        return $this->tabela;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return Operacao
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set registo
     *
     * @param string $registo
     * @return Operacao
     */
    public function setRegisto($registo)
    {
        $this->registo = $registo;

        return $this;
    }

    /**
     * Get registo
     *
     * @return string 
     */
    public function getRegisto()
    {
        return $this->registo;
    }

    /**
     * Set dado
     *
     * @param string $dado
     * @return Operacao
     */
    public function setDado($dado)
    {
        $this->dado = $dado;

        return $this;
    }

    /**
     * Get dado
     *
     * @return string 
     */
    public function getDado()
    {
        return $this->dado;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return Operacao
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return Operacao
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null)
    {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador()
    {
        return $this->utilizador;
    }
}
