<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Justificacao
 *
 * @ORM\Table(name="justificacao")
 * @ORM\Entity
 */
class Justificacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=50, nullable=false)
     */
    private $nome;

    /**
     * @var string
     *
     * @ORM\Column(name="justificacao", type="text", nullable=true)
     */
    private $justificacao;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="ComparticipacaoResposta", mappedBy="justificacao")
     */
    private $comparticipacaoR;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->comparticipacaoR = new \Doctrine\Common\Collections\ArrayCollection();
    }

    public function __toString() {
        return $this->nome;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return Justificacao
     */
    public function setNome($nome)
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * Set justificacao
     *
     * @param string $justificacao
     * @return Justificacao
     */
    public function setJustificacao($justificacao)
    {
        $this->justificacao = $justificacao;

        return $this;
    }

    /**
     * Get justificacao
     *
     * @return string 
     */
    public function getJustificacao()
    {
        return $this->justificacao;
    }

    /**
     * Add comparticipacaoR
     *
     * @param \Usoko\SIGBundle\Entity\ComparticipacaoResposta $comparticipacaoR
     * @return Justificacao
     */
    public function addComparticipacaoR(\Usoko\SIGBundle\Entity\ComparticipacaoResposta $comparticipacaoR)
    {
        $this->comparticipacaoR[] = $comparticipacaoR;

        return $this;
    }

    /**
     * Remove comparticipacaoR
     *
     * @param \Usoko\SIGBundle\Entity\ComparticipacaoResposta $comparticipacaoR
     */
    public function removeComparticipacaoR(\Usoko\SIGBundle\Entity\ComparticipacaoResposta $comparticipacaoR)
    {
        $this->comparticipacaoR->removeElement($comparticipacaoR);
    }

    /**
     * Get comparticipacaoR
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getComparticipacaoR()
    {
        return $this->comparticipacaoR;
    }
}
