<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Importacao
 *
 * @ORM\Table(name="importacao", indexes={@ORM\Index(name="fk_Importacao_Utilizador1_idx", columns={"Utilizador"})})
 * @ORM\Entity
 */
class Importacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var integer
     *
     * @ORM\Column(name="registo", type="integer", nullable=true)
     */
    private $registo;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=false)
     */
    private $tipo = 'A';

    /**
     * @var string
     *
     * @ORM\Column(name="ficheiro", type="string", length=100, nullable=true)
     */
    private $ficheiro;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return Importacao
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set registo
     *
     * @param integer $registo
     * @return Importacao
     */
    public function setRegisto($registo)
    {
        $this->registo = $registo;

        return $this;
    }

    /**
     * Get registo
     *
     * @return integer 
     */
    public function getRegisto()
    {
        return $this->registo;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Importacao
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set ficheiro
     *
     * @param string $ficheiro
     * @return Importacao
     */
    public function setFicheiro($ficheiro)
    {
        $this->ficheiro = $ficheiro;

        return $this;
    }

    /**
     * Get ficheiro
     *
     * @return string 
     */
    public function getFicheiro()
    {
        return $this->ficheiro;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return Importacao
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null)
    {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador()
    {
        return $this->utilizador;
    }
    
    public function __toString() {
        
    }
}
