<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * HistoricoImport
 *
 * @ORM\Table(name="historico_import", indexes={@ORM\Index(name="fk_hisAs", columns={"associado"}), @ORM\Index(name="fk_hisUti", columns={"utilizador"})})
 * @ORM\Entity
 */
class HistoricoImport
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="num_associado", type="string", length=100, nullable=true)
     */
    private $numAssociado;

    /**
     * @var float
     *
     * @ORM\Column(name="num_quotas", type="float", precision=10, scale=0, nullable=true)
     */
    private $numQuotas = '0';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numAssociado
     *
     * @param string $numAssociado
     * @return HistoricoImport
     */
    public function setNumAssociado($numAssociado)
    {
        $this->numAssociado = $numAssociado;

        return $this;
    }

    /**
     * Get numAssociado
     *
     * @return string 
     */
    public function getNumAssociado()
    {
        return $this->numAssociado;
    }

    /**
     * Set numQuotas
     *
     * @param float $numQuotas
     * @return HistoricoImport
     */
    public function setNumQuotas($numQuotas)
    {
        $this->numQuotas = $numQuotas;

        return $this;
    }

    /**
     * Get numQuotas
     *
     * @return float 
     */
    public function getNumQuotas()
    {
        return $this->numQuotas;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return HistoricoImport
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return HistoricoImport
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return HistoricoImport
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null)
    {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador()
    {
        return $this->utilizador;
    }
}
