<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * FuncionarioCargo
 *
 * @ORM\Table(name="funcionario_cargo", indexes={@ORM\Index(name="fk_Funcionario_has_Cargo_Cargo1_idx", columns={"Cargo"})})
 * @ORM\Entity
 */
class FuncionarioCargo
{
    /**
     * @var integer
     *
     * @ORM\Column(name="Funcionario", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $funcionario;

    /**
     * @var \Cargo
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="Cargo")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Cargo", referencedColumnName="id")
     * })
     */
    private $cargo;



    /**
     * Set funcionario
     *
     * @param integer $funcionario
     * @return FuncionarioCargo
     */
    public function setFuncionario($funcionario)
    {
        $this->funcionario = $funcionario;

        return $this;
    }

    /**
     * Get funcionario
     *
     * @return integer 
     */
    public function getFuncionario()
    {
        return $this->funcionario;
    }

    /**
     * Set cargo
     *
     * @param \Usoko\SIGBundle\Entity\Cargo $cargo
     * @return FuncionarioCargo
     */
    public function setCargo(\Usoko\SIGBundle\Entity\Cargo $cargo)
    {
        $this->cargo = $cargo;

        return $this;
    }

    /**
     * Get cargo
     *
     * @return \Usoko\SIGBundle\Entity\Cargo 
     */
    public function getCargo()
    {
        return $this->cargo;
    }
    
}
