<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CreditoPedido
 *
 * @ORM\Table(name="credito_pedido", uniqueConstraints={@ORM\UniqueConstraint(name="codigo", columns={"codigo"})}, indexes={@ORM\Index(name="fk_Pedido_Credito_Tipo_Credito1_idx", columns={"Tipo_Credito"}), @ORM\Index(name="fk_pedi_associado", columns={"Associado"}), @ORM\Index(name="fk_pedi_moeda", columns={"moeda"})})
 * @ORM\Entity
 */
class CreditoPedido
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var float
     *
     * @ORM\Column(name="valorPagar", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorpagar;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_mensal", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorMensal;

    /**
     * @var integer
     *
     * @ORM\Column(name="tempo_amortizacao", type="integer", nullable=false)
     */
    private $tempoAmortizacao;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo", type="string", length=50, nullable=false)
     */
    private $codigo;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=100, nullable=true)
     */
    private $anexo;

    /**
     * @var string
     *
     * @ORM\Column(name="urgencia", type="string", length=1, nullable=false)
     */
    private $urgencia = 'N';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_actual", type="datetime", nullable=false)
     */
    private $dataActual = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=2, nullable=true)
     */
    private $estado = 'P';

    /**
     * @var \TipoCredito
     *
     * @ORM\ManyToOne(targetEntity="TipoCredito")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Tipo_Credito", referencedColumnName="id")
     * })
     */
    private $tipoCredito;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="moeda", referencedColumnName="id")
     * })
     */
    private $moeda;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Pagamento", mappedBy="creditoPedido")
     */
    private $pagamento;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->pagamento = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return CreditoPedido
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set valorpagar
     *
     * @param float $valorpagar
     * @return CreditoPedido
     */
    public function setValorpagar($valorpagar)
    {
        $this->valorpagar = $valorpagar;

        return $this;
    }

    /**
     * Get valorpagar
     *
     * @return float 
     */
    public function getValorpagar()
    {
        return $this->valorpagar;
    }

    /**
     * Set valorMensal
     *
     * @param float $valorMensal
     * @return CreditoPedido
     */
    public function setValorMensal($valorMensal)
    {
        $this->valorMensal = $valorMensal;

        return $this;
    }

    /**
     * Get valorMensal
     *
     * @return float 
     */
    public function getValorMensal()
    {
        return $this->valorMensal;
    }

    /**
     * Set tempoAmortizacao
     *
     * @param integer $tempoAmortizacao
     * @return CreditoPedido
     */
    public function setTempoAmortizacao($tempoAmortizacao)
    {
        $this->tempoAmortizacao = $tempoAmortizacao;

        return $this;
    }

    /**
     * Get tempoAmortizacao
     *
     * @return integer 
     */
    public function getTempoAmortizacao()
    {
        return $this->tempoAmortizacao;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return CreditoPedido
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return CreditoPedido
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set urgencia
     *
     * @param string $urgencia
     * @return CreditoPedido
     */
    public function setUrgencia($urgencia)
    {
        $this->urgencia = $urgencia;

        return $this;
    }

    /**
     * Get urgencia
     *
     * @return string 
     */
    public function getUrgencia()
    {
        return $this->urgencia;
    }

    /**
     * Set dataActual
     *
     * @param \DateTime $dataActual
     * @return CreditoPedido
     */
    public function setDataActual($dataActual)
    {
        $this->dataActual = $dataActual;

        return $this;
    }

    /**
     * Get dataActual
     *
     * @return \DateTime 
     */
    public function getDataActual()
    {
        return $this->dataActual;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return CreditoPedido
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return CreditoPedido
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set tipoCredito
     *
     * @param \Usoko\SIGBundle\Entity\TipoCredito $tipoCredito
     * @return CreditoPedido
     */
    public function setTipoCredito(\Usoko\SIGBundle\Entity\TipoCredito $tipoCredito = null)
    {
        $this->tipoCredito = $tipoCredito;

        return $this;
    }

    /**
     * Get tipoCredito
     *
     * @return \Usoko\SIGBundle\Entity\TipoCredito 
     */
    public function getTipoCredito()
    {
        return $this->tipoCredito;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return CreditoPedido
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return CreditoPedido
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }

    /**
     * Add pagamento
     *
     * @param \Usoko\SIGBundle\Entity\Pagamento $pagamento
     * @return CreditoPedido
     */
    public function addPagamento(\Usoko\SIGBundle\Entity\Pagamento $pagamento)
    {
        $this->pagamento[] = $pagamento;

        return $this;
    }

    /**
     * Remove pagamento
     *
     * @param \Usoko\SIGBundle\Entity\Pagamento $pagamento
     */
    public function removePagamento(\Usoko\SIGBundle\Entity\Pagamento $pagamento)
    {
        $this->pagamento->removeElement($pagamento);
    }

    /**
     * Get pagamento
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPagamento()
    {
        return $this->pagamento;
    }
    
    public function __toString() {
        return $this->getCodigo();
    }
}
