<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BeneficioPagamento
 *
 * @ORM\Table(name="beneficio_pagamento", indexes={@ORM\Index(name="fk_pp_bp", columns={"planopensao"})})
 * @ORM\Entity
 */
class BeneficioPagamento
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="mes_ano", type="string", length=15, nullable=false)
     */
    private $mesAno;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_actual", type="datetime", nullable=true)
     */
    private $dataActual = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=false)
     */
    private $estado;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=false)
     */
    private $tipo = 'B';

    /**
     * @var \PlanoPensao
     *
     * @ORM\ManyToOne(targetEntity="PlanoPensao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="planopensao", referencedColumnName="id")
     * })
     */
    private $planopensao;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set mesAno
     *
     * @param string $mesAno
     * @return BeneficioPagamento
     */
    public function setMesAno($mesAno)
    {
        $this->mesAno = $mesAno;

        return $this;
    }

    /**
     * Get mesAno
     *
     * @return string 
     */
    public function getMesAno()
    {
        return $this->mesAno;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return BeneficioPagamento
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set dataActual
     *
     * @param \DateTime $dataActual
     * @return BeneficioPagamento
     */
    public function setDataActual($dataActual)
    {
        $this->dataActual = $dataActual;

        return $this;
    }

    /**
     * Get dataActual
     *
     * @return \DateTime 
     */
    public function getDataActual()
    {
        return $this->dataActual;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return BeneficioPagamento
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return BeneficioPagamento
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set planopensao
     *
     * @param \Usoko\SIGBundle\Entity\PlanoPensao $planopensao
     * @return BeneficioPagamento
     */
    public function setPlanopensao(\Usoko\SIGBundle\Entity\PlanoPensao $planopensao = null)
    {
        $this->planopensao = $planopensao;

        return $this;
    }

    /**
     * Get planopensao
     *
     * @return \Usoko\SIGBundle\Entity\PlanoPensao 
     */
    public function getPlanopensao()
    {
        return $this->planopensao;
    }
    
    public function __toString() {
        return $this->getMesAno();
    }
}
