<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AssociadoTipoinfraccao
 *
 * @ORM\Table(name="associado_tipoinfraccao", indexes={@ORM\Index(name="fk_TipoInfraccao_has_Associado_Associado1_idx", columns={"Associado"}), @ORM\Index(name="fk_TipoInfraccao_has_Associado_TipoInfraccao1_idx", columns={"TipoInfraccao"}), @ORM\Index(name="fk_Associado_TipoInfraccao_Utilizador1_idx", columns={"Utilizador"})})
 * @ORM\Entity
 */
class AssociadoTipoinfraccao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="string", length=50, nullable=true)
     */
    private $descricao;

    /**
     * @var \Tipoinfraccao
     *
     * @ORM\ManyToOne(targetEntity="Tipoinfraccao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TipoInfraccao", referencedColumnName="id")
     * })
     */
    private $tipoinfraccao;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return AssociadoTipoinfraccao
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set tipoinfraccao
     *
     * @param \Usoko\SIGBundle\Entity\Tipoinfraccao $tipoinfraccao
     * @return AssociadoTipoinfraccao
     */
    public function setTipoinfraccao(\Usoko\SIGBundle\Entity\Tipoinfraccao $tipoinfraccao = null)
    {
        $this->tipoinfraccao = $tipoinfraccao;

        return $this;
    }

    /**
     * Get tipoinfraccao
     *
     * @return \Usoko\SIGBundle\Entity\Tipoinfraccao 
     */
    public function getTipoinfraccao()
    {
        return $this->tipoinfraccao;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return AssociadoTipoinfraccao
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return AssociadoTipoinfraccao
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null)
    {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador()
    {
        return $this->utilizador;
    }
}
