<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * AssociadoDependentes
 *
 * @ORM\Table(name="associado_dependentes", indexes={@ORM\Index(name="fk_Dependentes_has_Associado_Associado1_idx", columns={"Associado"}), @ORM\Index(name="fk_Dependentes_has_Associado_Dependentes1_idx", columns={"Dependentes"}), @ORM\Index(name="fk_Associado_Dependentes_GrauParentesco1_idx", columns={"GrauParentesco"})})
 * @ORM\Entity
 */
class AssociadoDependentes
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="percentagem", type="float", precision=10, scale=0, nullable=false)
     */
    private $percentagem;

    /**
     * @var \Dependente
     *
     * @ORM\ManyToOne(targetEntity="Dependente", cascade={"persist"})
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Dependentes", referencedColumnName="id")
     * })
     */
    private $dependentes;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Grauparentesco
     *
     * @ORM\ManyToOne(targetEntity="Grauparentesco")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="GrauParentesco", referencedColumnName="id")
     * })
     */
    private $grauparentesco;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set percentagem
     *
     * @param float $percentagem
     * @return AssociadoDependentes
     */
    public function setPercentagem($percentagem)
    {
        $this->percentagem = $percentagem;

        return $this;
    }

    /**
     * Get percentagem
     *
     * @return float 
     */
    public function getPercentagem()
    {
        return $this->percentagem;
    }

    /**
     * Set dependentes
     *
     * @param \Usoko\SIGBundle\Entity\Dependente $dependentes
     * @return AssociadoDependentes
     */
    public function setDependentes(\Usoko\SIGBundle\Entity\Dependente $dependentes = null)
    {
        $this->dependentes = $dependentes;

        return $this;
    }

    /**
     * Get dependentes
     *
     * @return \Usoko\SIGBundle\Entity\Dependente 
     */
    public function getDependentes()
    {
        return $this->dependentes;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return AssociadoDependentes
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set grauparentesco
     *
     * @param \Usoko\SIGBundle\Entity\Grauparentesco $grauparentesco
     * @return AssociadoDependentes
     */
    public function setGrauparentesco(\Usoko\SIGBundle\Entity\Grauparentesco $grauparentesco = null)
    {
        $this->grauparentesco = $grauparentesco;

        return $this;
    }

    /**
     * Get grauparentesco
     *
     * @return \Usoko\SIGBundle\Entity\Grauparentesco 
     */
    public function getGrauparentesco()
    {
        return $this->grauparentesco;
    }
    
    public function __toString() {
        return $this->getAssociado()->getPessoa()->getNome();
    }
}
