<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Associado
 * @ORM\Table(name="associado", uniqueConstraints={@ORM\UniqueConstraint(name="nMecanografico_UNIQUE", columns={"n_Mecanografico"})}, indexes={@ORM\Index(name="fk_Funcionario_Pessoa1_idx", columns={"pessoa"}), @ORM\Index(name="fk_Associado_Orgaos1_idx", columns={"Orgao"}), @ORM\Index(name="fk_Associado_Cargo1_idx", columns={"Cargo"}), @ORM\Index(name="fk_associado_Conta", columns={"conta"}), @ORM\Index(name="fk_ass_pro", columns={"profissao"})})
* @ORM\Entity(repositoryClass="Usoko\SIGBundle\Repository\AssociadoRepository")
 */
class Associado {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="n_Mecanografico", type="integer", nullable=false)
     */
    private $nMecanografico;

    /**
     * @var float
     *
     * @ORM\Column(name="salario", type="float", precision=10, scale=0, nullable=false)
     */
    private $salario;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_admissao", type="date", nullable=false)
     */
    private $dataAdmissao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_associacao", type="datetime", nullable=false)
     */
    private $dataAssociacao = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=2, nullable=false)
     */
    private $tipo = 'A';

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=100, nullable=true)
     */
    private $anexo;

    /**
     * @var \Pessoa
     *
     * @ORM\ManyToOne(targetEntity="Pessoa", cascade={"persist"})
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="pessoa", referencedColumnName="id")
     * })
     */
    private $pessoa;

    /**
     * @var \Orgao
     *
     * @ORM\ManyToOne(targetEntity="Orgao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Orgao", referencedColumnName="id")
     * })
     */
    private $orgao;
    
    

    /**
     * @var \Cargo
     *
     * @ORM\ManyToOne(targetEntity="Cargo")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Cargo", referencedColumnName="id")
     * })
     */
    private $cargo;

    /**
     * @var string
     *
     * @ORM\Column(name="importado", type="string", length=1, nullable=false)
     */
    private $importado = 'N';
    
   

    /**
     * @var \BancoConta
     *
     * @ORM\ManyToOne(targetEntity="BancoConta", cascade={"persist"})
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="conta", referencedColumnName="id")
     * })
     */
    private $conta;

    /**
     * @var string
     *
     * @ORM\Column(name="status", type="string", length=2, nullable=false)
     */
    private $status = 'A';

    /**
     * @var \Profissao
     *
     * @ORM\ManyToOne(targetEntity="Profissao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="profissao", referencedColumnName="id")
     * })
     */
    private $profissao;

    /**
     * @var float
     *
     * @ORM\Column(name="saldoliquido", type="float", precision=10, scale=0, nullable=true)
     */
    private $saldoliquido;

    /**
     * @var string
     *
     * @ORM\Column(name="planopensao", type="string", length=1, nullable=false)
     */
    private $planopensao = 'N';

    /**
     * Get id
     *
     * @return integer 
     */

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=50, nullable=false)
     */
    private $numero;

    public function getId() {
        return $this->id;
    }

    /**
     * Set nMecanografico
     *
     * @param integer $nMecanografico
     * @return Associado
     */
    public function setNMecanografico($nMecanografico) {
        $this->nMecanografico = $nMecanografico;

        return $this;
    }

    /**
     * Get nMecanografico
     *
     * @return integer 
     */
    public function getNMecanografico() {
        return $this->nMecanografico;
    }

    /**
     * Set salario
     *
     * @param float $salario
     * @return Associado
     */
    public function setSalario($salario) {
        $this->salario = $salario;

        return $this;
    }

    /**
     * Get salario
     *
     * @return float 
     */
    public function getSalario() {
        return $this->salario;
    }

    /**
     * Set dataAdmissao
     *
     * @param \DateTime $dataAdmissao
     * @return Associado
     */
    public function setDataAdmissao($dataAdmissao) {
        $this->dataAdmissao = $dataAdmissao;

        return $this;
    }

    /**
     * Get dataAdmissao
     *
     * @return \DateTime 
     */
    public function getDataAdmissao() {
        return $this->dataAdmissao;
    }

    /**
     * Set dataAssociacao
     *
     * @param \DateTime $dataAssociacao
     * @return Associado
     */
    public function setDataAssociacao($dataAssociacao) {
        $this->dataAssociacao = $dataAssociacao;

        return $this;
    }

    /**
     * Get dataAssociacao
     *
     * @return \DateTime 
     */
    public function getDataAssociacao() {
        return $this->dataAssociacao;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Associado
     */
    public function setTipo($tipo) {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo() {
        return $this->tipo;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return Associado
     */
    public function setAnexo($anexo) {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo() {
        return $this->anexo;
    }

    /**
     * Set pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Associado
     */
    public function setPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa = null) {
        $this->pessoa = $pessoa;

        return $this;
    }

    /**
     * Get pessoa
     *
     * @return \Usoko\SIGBundle\Entity\Pessoa 
     */
    public function getPessoa() {
        return $this->pessoa;
    }

    /**
     * Set orgao
     *
     * @param \Usoko\SIGBundle\Entity\Orgao $orgao
     * @return Associado
     */
    public function setOrgao(\Usoko\SIGBundle\Entity\Orgao $orgao = null) {
        $this->orgao = $orgao;

        return $this;
    }

    /**
     * Get orgao
     *
     * @return \Usoko\SIGBundle\Entity\Orgao 
     */
    public function getOrgao() {
        return $this->orgao;
    }

    /**
     * Set conta
     *
     * @param \Usoko\SIGBundle\Entity\BancoConta $conta
     * @return Associado
     */
    public function setConta(\Usoko\SIGBundle\Entity\BancoConta $conta = null) {
        $this->conta = $conta;

        return $this;
    }

    /**
     * Get conta
     *
     * @return \Usoko\SIGBundle\Entity\BancoConta 
     */
    public function getConta() {
        return $this->conta;
    }

    /**
     * Set cargo
     *
     * @param \Usoko\SIGBundle\Entity\Cargo $cargo
     * @return Associado
     */

    /**
     * Set cargo
     *
     * @param \Usoko\SIGBundle\Entity\Cargo $cargo
     * @return Associado
     */
    public function setCargo(\Usoko\SIGBundle\Entity\Cargo $cargo = null) {
        $this->cargo = $cargo;

        return $this;
    }

    /**
     * Get cargo
     *
     * @return \Usoko\SIGBundle\Entity\Cargo 
     */
    public function getCargo() {
        return $this->cargo;
    }

    public function __toString() {
        return $this->pessoa->getNome();
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getStatus() {
        return $this->status;
    }

    /**
     * Set Status
     *
     * @param string $status
     * @return Associado
     */
    public function setStatus($status) {
        $this->status = $status;

        return $this;
    }

    /**
     * Set profissao
     *
     * @param \Usoko\SIGBundle\Entity\Profissao $profissao
     * @return Associado
     */
    public function setProfissao(\Usoko\SIGBundle\Entity\Profissao $profissao = null) {
        $this->profissao = $profissao;

        return $this;
    }

    /**
     * Get profissao
     *
     * @return \Usoko\SIGBundle\Entity\Profissao 
     */
    public function getProfissao() {
        return $this->profissao;
    }

    /**
     * Set importado
     *
     * @param string $importado
     * @return Associado
     */
    public function setImportado($importado) {
        $this->importado = $importado;

        return $this;
    }

    /**
     * Get importado
     *
     * @return string 
     */
    public function getImportado() {
        return $this->importado;
    }






    /**
     * Set saldoliquido
     *
     * @param float $saldoliquido
     * @return Associado
     */
    public function setSaldoliquido($saldoliquido) {
        $this->saldoliquido = $saldoliquido;

        return $this;
    }

    /**
     * Get saldoliquido
     *
     * @return float 
     */
    public function getSaldoliquido() {
        return $this->saldoliquido;
    }

    /**
     * Set planopensao
     *
     * @param string $planopensao
     * @return Associado
     */
    public function setPlanopensao($planopensao) {
        $this->planopensao = $planopensao;

        return $this;
    }

    /**
     * Get planopensao
     *
     * @return string 
     */
    public function getPlanopensao() {
        return $this->planopensao;
    }


    /**
     * Set numero
     *
     * @param string $numero
     * @return Associado
     */
    public function setNumero($numero)
    {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero
     *
     * @return string 
     */
    public function getNumero()
    {
        return $this->numero;
    }
    

    
}
