<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Tipopagamento;
use Usoko\SIGBundle\Form\TipopagamentoType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * Tipopagamento controller.
 *
 */
class TipopagamentoController extends Controller {

    /**
     * Lists all Tipopagamento entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Tipopagamento')->findAll();
        
        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Tipopagamento:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Tipopagamento entity.
     *
     */
    public function createAction(Request $request) {
        $valor = $this->valor($request);
        
        $entity = new Tipopagamento();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $entity->setValor((double) $valor);
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoPagamento", "I", "Registo de Um Novo Tipo Pagamento");
            $em->getConnection()->commit();
            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('tipopagamento_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Tipopagamento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Tipopagamento entity.
     *
     * @param Tipopagamento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Tipopagamento $entity) {
        $form = $this->createForm(new TipopagamentoType(), $entity, array(
            'action' => $this->generateUrl('tipopagamento_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Tipopagamento entity.
     *
     */
    public function newAction() {
        $entity = new Tipopagamento();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Tipopagamento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Tipopagamento entity.
     *
     */
    public function showAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Tipopagamento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipopagamento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Tipopagamento:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Tipopagamento entity.
     *
     */
    public function editAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Tipopagamento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipopagamento entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Tipopagamento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Tipopagamento entity.
     *
     * @param Tipopagamento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Tipopagamento $entity) {
        $id = CryptGeneral::encrypt($this, $entity->getId());
        $form = $this->createForm(new TipopagamentoType(), $entity, array(
            'action' => $this->generateUrl('tipopagamento_show', array('id' => $id)),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Tipopagamento entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $idR = $id;
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Tipopagamento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipopagamento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if (Validacao::validar($this, $entity) && $editForm->isValid()) {
            $em->getConnection()->beginTransaction();
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Tipopagamento", "U", "Actualização de Um Novo Tipopagamento");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('tipopagamento_edit', array('id' => $idR)));
        }

        return $this->render('UsokoSIGBundle:Tipopagamento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Tipopagamento entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = CryptGeneral::decrypt($this, $id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Tipopagamento')->find($id);
            
            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Tipopagamento entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Orgao", "D", "Remoção de Um Orgão");
            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }
        }

        return $this->redirect($this->generateUrl('tipopagamento'));
    }

    /**
     * Creates a form to delete a Tipopagamento entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = CryptGeneral::encrypt($this, $id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('tipopagamento_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }
    
    
    private function valor($request) {
        $valor =  $request->request->get('usoko_sigbundle_tipopagamento')['valor'] ;
        $valor = NumeroReal::converter($valor);
        return $valor;
    }

}
