<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Tipoinfraccao;
use Usoko\SIGBundle\Form\TipoinfraccaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\CryptGeneral;

/**
 * Tipoinfraccao controller.
 *
 */
class TipoinfraccaoController extends Controller {

    /**
     * Lists all Tipoinfraccao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Tipoinfraccao')->findAll();
        
        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Tipoinfraccao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Tipoinfraccao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Tipoinfraccao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && \Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoInfracao", "I", "Registo de Uma Nova Infração");
            $em->getConnection()->commit();
            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('tipoinfraccao_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Tipoinfraccao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Tipoinfraccao entity.
     *
     * @param Tipoinfraccao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Tipoinfraccao $entity) {
        $form = $this->createForm(new TipoinfraccaoType(), $entity, array(
            'action' => $this->generateUrl('tipoinfraccao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Tipoinfraccao entity.
     *
     */
    public function newAction() {
        $entity = new Tipoinfraccao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Tipoinfraccao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Tipoinfraccao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Tipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipoinfraccao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Tipoinfraccao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Tipoinfraccao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Tipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipoinfraccao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Tipoinfraccao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Tipoinfraccao entity.
     *
     * @param Tipoinfraccao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Tipoinfraccao $entity) {
        $form = $this->createForm(new TipoinfraccaoType(), $entity, array(
            'action' => $this->generateUrl('tipoinfraccao_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Tipoinfraccao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Tipoinfraccao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Tipoinfraccao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "TipoInfracao", "U", "Actualização de Uma Infração");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('tipoinfraccao'));
        }

        return $this->render('UsokoSIGBundle:Tipoinfraccao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Tipoinfraccao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = CryptGeneral::decrypt($this, $id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Tipoinfraccao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Tipoinfraccao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "TipoInfracao", "D", "Remoção de Uma Infração");

            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('tipoinfraccao'));
    }

    /**
     * Creates a form to delete a Tipoinfraccao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = CryptGeneral::encrypt($this, $id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('tipoinfraccao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
