<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Usoko\SIGBundle\Controller\PDFController;
use Usoko\SIGBundle\General\VarsGeneral;
use Symfony\Component\HttpFoundation\Request;
use Doctrine\ORM\Query;
use Usoko\SIGBundle\General\NasaPdf;

class RelatorioPPController extends PDFController {

    public function extractoAssociadoAction($id) {


        $em = $this->getDoctrine()->getManager();

        $query = $em->createQuery("SELECT pa.valor 
                                   FROM UsokoSIGBundle:PlanoPensao pp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
                                   UsokoSIGBundle:Pagamento pa,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where pp.associado = a.id
                                   and pa.tipopagamento = tp.id
                                   and tp.tipo = :tip
                                   and a.id = p.id
                                   and pp.estado =:estate
                                   and a.nMecanografico = :num
                                   order by pa.dataActual ASC")
                ->setParameters(array('tip' => VarsGeneral::CONS_TIPO_PAGAMENTO_PP,
            'num' => $id,
            'estate' => VarsGeneral::CONS_ASSOCIADO_TIPO_ASSOCIADO));
        $valor1 = $query->setMaxResults(1)->getSingleScalarResult();



        $query = $em->createQuery("SELECT pa 
                                   FROM UsokoSIGBundle:PlanoPensao pp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
                                   UsokoSIGBundle:Pagamento pa,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where pp.associado = a.id
                                   and pa.tipopagamento = tp.id
                                   and tp.tipo = :tip
                                   and a.id = p.id
                                   and pp.estado =:estate
                                   and a.nMecanografico = :num
                                   order by pa.dataActual ASC")
                ->setParameters(array('tip' => VarsGeneral::CONS_TIPO_PAGAMENTO_PP,
            'num' => $id,
            'estate' => VarsGeneral::CONS_ASSOCIADO_TIPO_ASSOCIADO));

        $saida = $query->getResult(Query::HYDRATE_ARRAY);


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/PP/extractoAssociado.html.twig', array('entities' => $saida, 'valor' => $valor1));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('extractoAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function associadoPlanoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT p.nome as nomes, a.nMecanografico as nMec, pp.data as dada,
								   pp.valor as valores
                                   FROM UsokoSIGBundle:PlanoPensao pp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where pp.associado = a.id
                                   and a.id = p.id
                                   and pp.estado <> :state
                                    ")->setParameter('state', 'A');

        $saida = $query->getResult();


		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioAssociadosNoPP($saida);
		$declaracao->Output("associadosNoPP.pdf", 'I');
		
        

    }

    public function extractoPersonalizadoAction(Request $req) {
        $em = $this->getDoctrine()->getManager();

        $dataInicio = $req->request->get('datainicio');
        $dataFim = $req->request->get('datafim');
        $codigo = $req->request->get('codigos');

        $id = $this->get('nzo_url_encryptor')->decrypt($codigo);

        if ($req->request->get('tipo_relatorio') == 'QUO') {

            $response = $this->forward('UsokoSIGBundle:RelatorioPP:extractoQuota', array(
                'data1' => $dataInicio,
                'data2' => $dataFim,
                'id' => $id
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'CRE') {

            $response = $this->forward('UsokoSIGBundle:RelatorioPP:extractoCredito', array(
                'data1' => $dataInicio,
                'data2' => $dataFim,
                'id' => $id
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'PPE') {

            $response = $this->forward('UsokoSIGBundle:RelatorioPP:extractoPlanoPensao', array(
                'data1' => $dataInicio,
                'data2' => $dataFim,
                'id' => $id
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'GER') {
            $response = $this->forward('UsokoSIGBundle:RelatorioPP:extractoGeral', array(
                'data1' => $dataInicio,
                'data2' => $dataFim,
                'id' => $id
            )); 
			return $response;
        }
		else{
		die('');
		}
    }

    public function extractoPlanoPensaoAction($data1, $data2, $id) {

        $em = $this->getDoctrine()->getManager();

        $query2 = $em->createQuery("SELECT pe.nome 
                                    FROM UsokoSIGBundle:Associado a,
                                    UsokoSIGBundle:Pessoa pe
                                    where a.pessoa = pe.id
                                    and a.id =:codigo
                                   ")->setParameters(array('codigo' =>(int)$id));


        $pessoa = $query2->getResult();

        
        $query = $em->createQuery("SELECT p 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where p.associado   = a.id
                                   and p.tipopagamento = tp.id
                                   and tp.tipo = ?1
                                   and p.associado = ?2
                                   and p.dataActual BETWEEN ?3 AND ?4
								   ");
        $query->setParameter(1, 'PP');
        $query->setParameter(2, (int)$id);
        $query->setParameter(3, $data1);
        $query->setParameter(4, $data2);
		
        $saida = $query->getResult();
		
		
		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoPlano($saida,$data1,$data2,$pessoa[0]['nome']);
		$declaracao->Output("PlanoDePensoes.pdf", 'I');
		
    }

    public function extractoQuotaAction($data1, $data2, $id) {

        $em = $this->getDoctrine()->getManager();

        $query2 = $em->createQuery("SELECT pe.nome 
                                   FROM UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where a.pessoa = pe.id
                                   and a.id =:codigo
                                   ")->setParameters(array('codigo' => (int)$id));


        $pessoa = $query2->getResult();

        $nome = $pessoa[0]['nome'];
		
		$query = $em->createQuery("SELECT p 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where p.associado   = a.id
                                   and p.tipopagamento = tp.id
                                   and tp.tipo = ?1
                                   and p.associado = ?2
                                   and p.dataActual BETWEEN ?3 AND ?4
                                   ");
        $query->setParameter(1, 'Q');
        $query->setParameter(2, (int)$id);
        $query->setParameter(3, $data1);
        $query->setParameter(4, $data2);

        $saida = $query->getResult();
		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoQuota($saida,$data1,$data2,$nome);
		$declaracao->Output("extractoQuota.pdf", 'I');
		
        
        
    }

    public function extractoCreditoAction($data1, $data2, $id) {

        $em = $this->getDoctrine()->getManager();

        $query2 = $em->createQuery("SELECT pe.nome 
                                   FROM UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where a.pessoa = pe.id
                                   and a.id =:codigo
                                   ")->setParameters(array('codigo'=>(int)$id));

        $pessoa = $query2->getResult();

		$nome = $pessoa[0]['nome'];

        $query = $em->createQuery("SELECT p 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Tipopagamento tp,
								   UsokoSIGBundle:CreditoPedido cp
                                   where p.associado   = a.id
								   and cp.associado = a.id
                                   and p.tipopagamento = tp.id
                                   and tp.tipo = ?1 and a.id = ?2
                                   and p.dataActual BETWEEN ?3 AND ?4
                                   ");

        $query->setParameter(1, 'C');
        $query->setParameter(2, (int)$id);
        $query->setParameter(3, $data1);
        $query->setParameter(4, $data2);

		$saida = $query->getResult();
		
		
		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoCredito($saida,$data1,$data2,$nome);
		$declaracao->Output("ExtractoAssociado.pdf", 'I');
		
		
		
      
    }
	
	
	public function extractoGeralAction($data1, $data2, $id) {

        $em = $this->getDoctrine()->getManager();

        $query2 = $em->createQuery("SELECT pe.nome 
                                   FROM UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where a.pessoa = pe.id
                                   and a.id =:codigo
                                   ")->setParameters(array('codigo'=>(int)$id));

        $pessoa = $query2->getResult();

		$nome = $pessoa[0]['nome'];

        $query = $em->createQuery("SELECT p 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Tipopagamento tp,
								   UsokoSIGBundle:CreditoPedido cp
                                   where p.associado   = a.id
								   and cp.associado = a.id
                                   and p.tipopagamento = tp.id
                                   and a.id = ?1
                                   and p.dataActual BETWEEN ?2 AND ?3
								   order by p.tipopagamento,p.mesAno, p.dataActual ASC
                                   ");

        $query->setParameter(1, (int)$id);
        $query->setParameter(2, $data1);
        $query->setParameter(3, $data2);

		$saida = $query->getResult();
		
		
		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoExtratoGeral($saida,$data1,$data2,$nome);
		$declaracao->Output("ExtractoGeralAssociado.pdf", 'I');
		
		
		
      
    }
	

    public function associadoDesvinculadosAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT distinct(p.nome) as nomeDele,
                                   a.nMecanografico as nMec, ppp.pago as pagou,
								   sum(ppp.valortotalpp) as val, ppp.data as actual
                                   FROM 
                                   UsokoSIGBundle:PlanoPensao pp,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
								   UsokoSIGBundle:PpDesvinculacao ppp
                                   where a.pessoa = p.id
								   and   pp.associado = a.id
								   and ppp.planoPensao=pp.id
								   group by pp.associado
								   order by nomeDele
                                   ');

        $saida = $query->getResult();


        
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioAssociadosDesvinculadosPP($saida);
		$declaracao->Output("associadosNoPP.pdf", 'I');
    }
	
	
	

}
