<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Usoko\SIGBundle\Controller\PDFController;
use Usoko\SIGBundle\General\FuncaoGeneral;
use Usoko\SIGBundle\General\NasaPdf;

class RelatorioController extends PDFController {

    public function comparticipacao_tipoSubsidioAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, SUM(c.valor) as valor 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s
                                   where c.subsidio = s.id
                                   GROUP BY c.subsidio");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacao_tipoSubsidio.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacao_tipoSubsidio.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function comparticipacaoQtdAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, count(c.associado) as pessoas 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s, UsokoSIGBundle:Associado a 
                                   where c.subsidio = s.id
                                   and  c.associado  = a.id
                                    ");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoQtdAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoQtdAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

//Entradas e saídas


    public function comparticipacaoMensalAction() {

        $em = $this->getDoctrine()->getManager();

        $query = $em->createQuery("SELECT SUM(c.valor) as total 
                                   FROM UsokoSIGBundle:Comparticipacao c
                                   ");


        $saida = $query->getSingleScalarResult();

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function quotaMensalAction() {

        $em = $this->getDoctrine()->getManager();


        for ($dia = 1; $dia <= 12; $dia++) {
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $ano = date('Y') . '-' . "$mes";
            $i = '%' . $ano . '%';

            $query = $em->createQuery("SELECT SUM(c.valor) FROM UsokoSIGBundle:Comparticipacao c 
                                       JOIN c.subsidio s WITH substring(c.dataActual,1,7) 
                                       LIKE :foo");
            $query->setParameter('foo', "$i");
            $saida = $query->getSingleScalarResult();

            $vetor_dados[] = is_null($saida) ? 0 : $saida;
        }

        $saida = $vetor_dados;

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/quotaMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('quotaMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function relatorioInfracaoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT at as infra, count(at.associado) as qtd,
                                   pe.nome as nome  
                                   FROM UsokoSIGBundle:AssociadoTipoinfraccao at,
                                   UsokoSIGBundle:Tipoinfraccao t,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where at.associado = a.id 
                                   AND at.tipoinfraccao = t.id
                                   AND pe.id=a.pessoa
                                   GROUP BY at.associado, at.tipoinfraccao
                                   ORDER BY qtd ASC");
        $saida = $query->getResult();


		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioInfraccao($saida);
		$declaracao->Output("RelatorioInfraccoes.pdf", 'I');
		
        
    }

    public function associadoPagamentoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT sum(p.valor) as total,a.nMecanografico as meca
                                   ,pe.nome as nome, a.dataAssociacao as data 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where p.associado = a.id 
                                   and a.pessoa=pe.id
                                   GROUP BY p.associado, p.tipopagamento
                                   ORDER BY total ASC");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/pagamentosAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('associadoPagamento.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function relatorioPersonalizadoAction(Request $req) {

        //$ab = $req->request->get('okok');

        $em = $this->getDoctrine()->getManager();

        $dataInicio = $req->request->get('datainicio');
        $dataFim = $req->request->get('datafim');

        if ($req->request->get('tipo_relatorio') == 'AQ') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoAssociadoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AC') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoQtdAssociadoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AP') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:associadoPagamentoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AI') {
            $response = $this->forward('UsokoSIGBundle:Relatorio:relatorioInfracao');

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'SU') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaotipoSubsidioIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else {

            $dia = FuncaoGeneral::retornaMes($ab);
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $ano = date('Y') . '-' . "$mes";
            $i = '%' . $ano . '%';

            $query = $em->createQuery("SELECT SUM(c.valor) as aa FROM UsokoSIGBundle:Comparticipacao c 
                                      JOIN c.subsidio s WITH substring(c.dataActual,1,7) 
                                      LIKE :foo");
            $query->setParameter('foo', "$i");
            $saida = $query->getSingleScalarResult();

            $vetor_dados = is_null($saida) ? 0 : $saida;

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/ApenasUmMes.html.twig', array('entities' => $saida, 'mes' => $ab));

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output("quota.pdf", 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        }
    }

    /* ########################################################################## */


    /* Intervalo de duas datas */

    public function comparticipacaoAssociadoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT c as ab, SUM(c.valor) as total,
                                   p.nome as nome, a.nMecanografico as nMecanografico,s.tipo as subs
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Pessoa p, 
								   UsokoSIGBundle:Associado a,
								   UsokoSIGBundle:Subsidio s 	
                                   WHERE c.associado= a.id
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                   AND a.pessoa = p.id
								   AND c.subsidio =  s.id 
                                   GROUP BY c.associado,s
                                   ORDER BY nome,subs,a.nMecanografico');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();


		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioComparticipacao($saida,$data1,$data2);
		$declaracao->Output("RelatorioComparticipacao.pdf", 'I');
		
        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/intervalo.html.twig', array('entities' => $saida, 'inicio' => $data1, 'fim' => $data2));

        
    }

    /* Geral Sempre */

    public function comparticipacaoAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT c as ab, SUM(c.valor) as total,
                                   p.nome as nome, a.nMecanografico as nMecanografico
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                   WHERE c.associado= a.id
                                   AND a.pessoa = p.id
                                   GROUP BY c.associado
                                   ORDER BY a.nMecanografico");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    /* Ano Mês */

    public function comparticipacaoAssociadoAnoMesAction($ano, $mes1) {

        $em = $this->getDoctrine()->getManager();

        if ($mes1 != 'Geral') {
            $dia = FuncaoGeneral::retornaMes($mes1);
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $anos = $ano . '-' . "$mes";
            $i = '%' . $anos . '%';



            $query = $em->createQuery("SELECT c as ab, SUM(c.valor) as total,
                                       p.nome as nome, a.nMecanografico as nMecanografico
                                       FROM UsokoSIGBundle:Comparticipacao c,
                                       UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                       WHERE substring(c.dataActual,1,7) LIKE :foo
                                       AND c.associado= a.id
                                       AND a.pessoa = p.id
                                       GROUP BY c.associado
                                       ORDER BY a.nMecanografico")
                    ->setParameter('foo', "$i");

            $saida = $query->getResult();


            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/AnoMes.html.twig', array('entities' => $saida, 'ano' => $ano, 'mes' => $mes1));

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output('AnoMes.pdf', 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        } else if ($mes1 == 'Geral') {
            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoAssociadoGeralAno', array(
                'ano' => $ano,
                'mes1' => $mes1
            ));

            return $response;
        }
    }

    /* Geral Ano */

    public function comparticipacaoAssociadoGeralAnoAction($ano, $mes1) {

        $em = $this->getDoctrine()->getManager();


        if ($mes1 == 'Geral') {

            for ($dia = 1; $dia <= 12; $dia++) {
                $dia = (string) $dia;
                if ($dia <= 9) {
                    $mes = '0' . "$dia";
                } else {
                    $mes = '' . "$dia";
                }
                $anos = $ano . '-' . "$mes";
                $i = '%' . $anos . '%';


                $query = $em->createQuery(" SELECT c as ab, SUM(c.valor) as total,
                                            p.nome as nome, a.nMecanografico as nMecanografico
                                            FROM UsokoSIGBundle:Comparticipacao c,
                                            UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                            WHERE substring(c.dataActual,1,8) LIKE :foo
                                            AND c.associado= a.id
                                            AND a.pessoa = p.id
                                            GROUP BY c.associado
                                            ORDER BY a.nMecanografico");

                $query->setParameter('foo', "$i");
                $saida[] = $query->getResult();
                //$vetor_dados[] = is_null($saida) ? 0 : $saida;
            }

            //$saida = $vetor_dados;

            var_dump($saida);
            die;




            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/GeralAno.html.twig', array('entities' => $saida, 'ano' => $ano, 'mes' => $mes1));

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output('GeralAno.pdf', 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        }
    }

    public function associadoPagamentoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();

        /*$data1 = (string) ($data1);
        $data2 = (string) ($data2);

        $d1 = $data1;
        $d2 = $data2;

		
        $ano1 = substr($data1, 0, 4);
        $mes1 = substr($data1, 5, 2);

        $data1 = $mes1 . "/" . $ano1;

        $ano2 = substr($data2, 0, 4);
        $mes2 = substr($data2, 5, 2);

        $data2 = $mes2 . "/" . $ano2; 

		
		
	   //echo "$data1"."<br />";
	   //echo "$data2"."<br />";	die;*/

        $query = $em->createQuery("SELECT sum(p.valor) as total,a.nMecanografico as meca
                                   ,pe.nome as nome, a.dataAssociacao as data,
									CASE WHEN tp.tipo='C' THEN 'Crédito'
									WHEN tp.tipo='Q' THEN 'Quota'
									WHEN tp.tipo='PP' THEN 'Plano de Pensão'
									WHEN tp.tipo='J' THEN 'Jóia'
									ELSE '__'
									END as tipos
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where p.dataActual BETWEEN :dat1 AND :dat2
								   AND p.associado = a.id 
                                   AND p.tipopagamento=tp.id
                                   AND a.pessoa = pe.id
                                   GROUP BY p.associado, p.tipopagamento
                                   ORDER BY nome,tipos,total ASC");


        $query->setParameters(array('dat1' => $data1, 'dat2' => $data2));

        $saida = $query->getResult();

		
		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioPagamento($saida,$data1,$data2);
		$declaracao->Output("PlanoDePensoes.pdf", 'I');
			
        
    }

    public function comparticipacaotipoSubsidioIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        //die($data2);
        $query = $em->createQuery('SELECT s.tipo as tipo, SUM(c.valor) as valor 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s
                                   where c.subsidio = s.id 
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                   GROUP BY c.subsidio');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();

		
		$this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
		$declaracao = new NasaPdf($this,1,1,1);
		$declaracao->corpoRelatorioSubsidio($saida,$data1,$data2);
		$declaracao->Output("RelatorioSubsidio.pdf", 'I');

        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/ComparticipacaoSubsidio/intervalo.html.twig', array('entities' => $saida,
          
        
    }

    public function comparticipacaoQtdAssociadoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT s.tipo as tipo, count(c.associado) as pessoas 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s, UsokoSIGBundle:Associado a 
                                   where c.subsidio  = s.id
                                   and  c.associado  = a.id
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                    ');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/ComparticipacaoQtdAssociado/intervalo.html.twig', array('entities' => $saida,
            'inicio' => $data1,
            'fim' => $data2));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoQtdAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function pagamentoSubsidioIntervaloAction(Request $req) {


        $mesEmQuestao = $req->request->get('mesEmQuestao');
        $mes = FuncaoGeneral::retornaMes($mesEmQuestao) <= 9 ? '0' . FuncaoGeneral::retornaMes($mesEmQuestao) : FuncaoGeneral::retornaMes($mesEmQuestao);
        $anoxx = (int) date('Y');
        $data1 = new \DateTime("{$anoxx}-{$mes}-01");
        $data2 = clone $data1;
        $data2->modify("last day of this month");

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT distinct(p.nome) as NomeDele,a.nMecanografico as Mec,
                                   s.tipo as tiposub, c.valor as massa
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:ComparticipacaoResposta cr,
                                   UsokoSIGBundle:Subsidio s, 
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where c.subsidio  = s.id
                                   and  c.associado  = a.id
                                   and cr.resposta =?1
                                   and cr.comparticipacao = c.id
                                   and a.pessoa = p.id
                                   and c.estado !=?2
                                   and c.dataActual BETWEEN ?3 AND ?4
                                   order by NomeDele,tiposub
                                    ');


        $query->setParameter(1, 'A');
        $query->setParameter(2, 'C');
        $query->setParameter(3, $data1);
        $query->setParameter(4, $data2);
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Saque/ficheiroMensalSubsidio.html.twig', array('entities' => $saida,
            'inicio' => $data1,
            'fim' => $data2));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('ficheiroMensalSubsidio.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function pagamentoCreditoIntervaloAction(Request $req) {

        $mesEmQuestao = $req->request->get('mesEmQuestao');
        $mes = FuncaoGeneral::retornaMes($mesEmQuestao) <= 9 ? '0' . FuncaoGeneral::retornaMes($mesEmQuestao) : FuncaoGeneral::retornaMes($mesEmQuestao);
        $anoxx = (int) date('Y');
        $data1 = new \DateTime("{$anoxx}-{$mes}-01");
        $data2 = clone $data1;
        $data2->modify("last day of this month");


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT cp.dataActual,tc.nome , p.nome as NomeDele,
                                   a.nMecanografico as Mec, cp.id as codE,
                                   cp.codigo as codex,
                                   cr.valorMensal as massa
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:CreditoResposta cr,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where cr.creditoPedido = cp.id
                                   and cp.tipoCredito=tc.id
                                   and cr.resposta =?1
                                   and a.pessoa = p.id
                                   and  cp.associado  = a.id
                                   and cr.data BETWEEN ?2 AND ?3
				   order by tc.nome,NomeDele
                                   ');

        $query->setParameter(1, 'A');
        $query->setParameter(2, $data1);
        $query->setParameter(3, $data2);
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Saque/ficheiroMensalCredito.html.twig', array('entities' => $saida,
            'inicio' => $data1,
            'fim' => $data2));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('ficheiroMensalCredito.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function confirmarPagamentoCreditoBancoAction(Request $req) {
        $id = $req->request->get('codigo');
        
        $em = $this->getDoctrine()->getManager();
        $creditoResposta = $em->getRepository('UsokoSIGBundle:CreditoPedido')->find($id);
        if (!$creditoResposta) {
            $resposta='nao'; 
         return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoCredito.html.twig', array(
        'resposta' => $resposta
                  ));			
        }
		$resposta='sim';  
        $creditoResposta->setEstado('AP');
        $em->flush();
        
        return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoCredito.html.twig', array(
        'resposta' => $resposta
                  ));
        
        
    }
	
	public function confirmarPagamentoDesvinculadosBancoAction(Request $req) {
        $id = $req->request->get('codigo');
        
        $em = $this->getDoctrine()->getManager();
        $creditoResposta = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);
        if (!$creditoResposta) {
            $resposta='nao'; 
         return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoDesvinculados.html.twig', array(
        'resposta' => $resposta
                  ));			
        }
		$resposta='sim';  
        $creditoResposta->setPago('N');
        $em->flush();
        
        return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoDesvinculados.html.twig', array(
        'resposta' => $resposta
                  ));
        
        
    }
	

}
