<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpFoundation\Request;
use Usoko\SIGBundle\Controller\PDFController;
use Usoko\SIGBundle\General\FuncaoGeneral;
use Usoko\SIGBundle\General\NasaPdf;
use Symfony\Component\HttpFoundation\JsonResponse;

class RelatorioController extends PDFController {

    public function comparticipacao_tipoSubsidioAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, SUM(c.valor) as valor 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s
                                   where c.subsidio = s.id
                                   GROUP BY c.subsidio");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacao_tipoSubsidio.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacao_tipoSubsidio.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function comparticipacaoQtdAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT s.tipo as tipo, count(c.associado) as pessoas 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s, UsokoSIGBundle:Associado a 
                                   where c.subsidio = s.id
                                   and  c.associado  = a.id
                                    ");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoQtdAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoQtdAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

//Entradas e saídas


    public function comparticipacaoMensalAction() {

        $em = $this->getDoctrine()->getManager();

        $query = $em->createQuery("SELECT SUM(c.valor) as total 
                                   FROM UsokoSIGBundle:Comparticipacao c
                                   ");


        $saida = $query->getSingleScalarResult();

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('GAM');
        $html2pdf->pdf->SetTitle('GAM');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function quotaMensalAction() {

        $em = $this->getDoctrine()->getManager();


        for ($dia = 1; $dia <= 12; $dia++) {
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $ano = date('Y') . '-' . "$mes";
            $i = '%' . $ano . '%';

            $query = $em->createQuery("SELECT SUM(c.valor) FROM UsokoSIGBundle:Comparticipacao c 
                                       JOIN c.subsidio s WITH substring(c.dataActual,1,7) 
                                       LIKE :foo");
            $query->setParameter('foo', "$i");
            $saida = $query->getSingleScalarResult();

            $vetor_dados[] = is_null($saida) ? 0 : $saida;
        }

        $saida = $vetor_dados;

        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/quotaMensal.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('quotaMensal.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function relatorioInfracaoAction() {


        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT t.nome as infra, count(at.associado) as qtd,
                                   pe.nome as nome  
                                   FROM UsokoSIGBundle:AssociadoTipoinfraccao at,
                                   UsokoSIGBundle:Tipoinfraccao t,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where at.associado = a.id 
                                   AND at.tipoinfraccao = t.id
                                   AND pe.id=a.pessoa
                                   GROUP BY at.associado, at.tipoinfraccao
                                   ORDER BY qtd ASC");
        $saida = $query->getResult();


        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioInfraccao($saida);
        $declaracao->Output("RelatorioInfraccoes.pdf", 'I');
    }

    public function associadoPagamentoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT sum(p.valor) as total,a.nMecanografico as meca
                                   ,pe.nome as nome, a.dataAssociacao as data 
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe
                                   where p.associado = a.id 
                                   and a.pessoa=pe.id
                                   GROUP BY p.associado, p.tipopagamento
                                   ORDER BY total ASC");
        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/pagamentosAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('associadoPagamento.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    public function relatorioPersonalizadoAction(Request $req) {

        //$ab = $req->request->get('okok');

        $em = $this->getDoctrine()->getManager();

        $dataInicio = $req->request->get('datainicio');
        $dataFim = $req->request->get('datafim');

        if ($req->request->get('tipo_relatorio') == 'AQ') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoAssociadoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AC') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoQtdAssociadoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AP') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:associadoPagamentoIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'AI') {
            $response = $this->forward('UsokoSIGBundle:Relatorio:relatorioInfracao');

            return $response;
        } else if ($req->request->get('tipo_relatorio') == 'SU') {

            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaotipoSubsidioIntervalo', array(
                'data1' => $dataInicio,
                'data2' => $dataFim
            ));

            return $response;
        } else {

            $dia = FuncaoGeneral::retornaMes($ab);
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $ano = date('Y') . '-' . "$mes";
            $i = '%' . $ano . '%';

            $query = $em->createQuery("SELECT SUM(c.valor) as aa FROM UsokoSIGBundle:Comparticipacao c 
                                      JOIN c.subsidio s WITH substring(c.dataActual,1,7) 
                                      LIKE :foo");
            $query->setParameter('foo', "$i");
            $saida = $query->getSingleScalarResult();

            $vetor_dados = is_null($saida) ? 0 : $saida;

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/ApenasUmMes.html.twig', array('entities' => $saida, 'mes' => $ab));

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output("quota.pdf", 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        }
    }

    /* ########################################################################## */


    /* Intervalo de duas datas */

    public function comparticipacaoAssociadoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT c as ab, SUM(c.valor) as total,
                                   p.nome as nome, a.nMecanografico as nMecanografico,s.tipo as subs
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Pessoa p, 
								   UsokoSIGBundle:Associado a,
								   UsokoSIGBundle:Subsidio s 	
                                   WHERE c.associado= a.id
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                   AND a.pessoa = p.id
								   AND c.subsidio =  s.id 
                                   GROUP BY c.associado,s
                                   ORDER BY nome,subs,a.nMecanografico');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();



        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioComparticipacao($saida, $data1, $data2);
        $declaracao->Output("RelatorioComparticipacao.pdf", 'I');

        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/intervalo.html.twig', array('entities' => $saida, 'inicio' => $data1, 'fim' => $data2));
    }

    /* Geral Sempre */

    public function comparticipacaoAssociadoAction() {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT c as ab, SUM(c.valor) as total,
                                   p.nome as nome, a.nMecanografico as nMecanografico
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                   WHERE c.associado= a.id
                                   AND a.pessoa = p.id
                                   GROUP BY c.associado
                                   ORDER BY a.nMecanografico");

        $saida = $query->getResult();


        $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/comparticipacaoAssociado.html.twig', array('entities' => $saida));

        $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

        $html2pdf->pdf->SetAuthor('Usoko');
        $html2pdf->pdf->SetTitle('Usoko');

        $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $html2pdf->pdf->SetFont('helvetica', '', 11);
        $html2pdf->pdf->setPrintHeader('Ola Mundo');
        $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

        $html2pdf->pdf->SetDisplayMode('real');

        $html2pdf->writeHTML($html);
        $html2pdf->Output('comparticipacaoAssociado.pdf', 'I');

        $resposta = new Response();
        $resposta->headers->set('Content-Type', 'application/pdf');

        return $resposta;
    }

    /* Ano Mês */

    public function comparticipacaoAssociadoAnoMesAction($ano, $mes1) {

        $em = $this->getDoctrine()->getManager();

        if ($mes1 != 'Geral') {
            $dia = FuncaoGeneral::retornaMes($mes1);
            $dia = (string) $dia;
            if ($dia <= 9) {
                $mes = '0' . "$dia";
            } else {
                $mes = '' . "$dia";
            }
            $anos = $ano . '-' . "$mes";
            $i = '%' . $anos . '%';



            $query = $em->createQuery("SELECT c as ab, SUM(c.valor) as total,
                                       p.nome as nome, a.nMecanografico as nMecanografico
                                       FROM UsokoSIGBundle:Comparticipacao c,
                                       UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                       WHERE substring(c.dataActual,1,7) LIKE :foo
                                       AND c.associado= a.id
                                       AND a.pessoa = p.id
                                       GROUP BY c.associado
                                       ORDER BY a.nMecanografico")
                    ->setParameter('foo', "$i");

            $saida = $query->getResult();


            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/AnoMes.html.twig', array('entities' => $saida, 'ano' => $ano, 'mes' => $mes1));

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output('AnoMes.pdf', 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        } else if ($mes1 == 'Geral') {
            $response = $this->forward('UsokoSIGBundle:Relatorio:comparticipacaoAssociadoGeralAno', array(
                'ano' => $ano,
                'mes1' => $mes1
            ));

            return $response;
        }
    }

    /* Geral Ano */

    public function comparticipacaoAssociadoGeralAnoAction($ano, $mes1) {

        $em = $this->getDoctrine()->getManager();


        if ($mes1 == 'Geral') {

            for ($dia = 1; $dia <= 12; $dia++) {
                $dia = (string) $dia;
                if ($dia <= 9) {
                    $mes = '0' . "$dia";
                } else {
                    $mes = '' . "$dia";
                }
                $anos = $ano . '-' . "$mes";
                $i = '%' . $anos . '%';


                $query = $em->createQuery(" SELECT c as ab, SUM(c.valor) as total,
                                            p.nome as nome, a.nMecanografico as nMecanografico
                                            FROM UsokoSIGBundle:Comparticipacao c,
                                            UsokoSIGBundle:Pessoa p, UsokoSIGBundle:Associado a 
                                            WHERE substring(c.dataActual,1,8) LIKE :foo
                                            AND c.associado= a.id
                                            AND a.pessoa = p.id
                                            GROUP BY c.associado
                                            ORDER BY a.nMecanografico");

                $query->setParameter('foo', "$i");
                $saida[] = $query->getResult();
                //$vetor_dados[] = is_null($saida) ? 0 : $saida;
            }

            //$saida = $vetor_dados;

            var_dump($saida);
            die;




            $html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/comparticipacaoAssociado/GeralAno.html.twig', array('entities' => $saida, 'ano' => $ano, 'mes' => $mes1));

            $html2pdf = new \Html2Pdf_Html2Pdf('P', 'A4', 'en');

            $html2pdf->pdf->SetAuthor('Usoko');
            $html2pdf->pdf->SetTitle('Usoko');

            $html2pdf->pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
            $html2pdf->pdf->SetFont('helvetica', '', 11);
            $html2pdf->pdf->setPrintHeader('Ola Mundo');
            $html2pdf->pdf->setPrintFooter(date('d-m-Y'));

            $html2pdf->pdf->SetDisplayMode('real');

            $html2pdf->writeHTML($html);
            $html2pdf->Output('GeralAno.pdf', 'I');

            $resposta = new Response();
            $resposta->headers->set('Content-Type', 'application/pdf');

            return $resposta;
        }
    }

    public function associadoPagamentoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();

        /* $data1 = (string) ($data1);
          $data2 = (string) ($data2);

          $d1 = $data1;
          $d2 = $data2;


          $ano1 = substr($data1, 0, 4);
          $mes1 = substr($data1, 5, 2);

          $data1 = $mes1 . "/" . $ano1;

          $ano2 = substr($data2, 0, 4);
          $mes2 = substr($data2, 5, 2);

          $data2 = $mes2 . "/" . $ano2;



          //echo "$data1"."<br />";
          //echo "$data2"."<br />";	die; */

        $query = $em->createQuery("SELECT sum(p.valor) as total,a.nMecanografico as meca
                                   ,pe.nome as nome, a.dataAssociacao as data,
									CASE WHEN tp.tipo='C' THEN 'Crédito'
									WHEN tp.tipo='Q' THEN 'Quota'
									WHEN tp.tipo='PP' THEN 'Plano de Pensão'
									WHEN tp.tipo='J' THEN 'Jóia'
									ELSE '__'
									END as tipos
                                   FROM UsokoSIGBundle:Pagamento p,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa pe,
                                   UsokoSIGBundle:Tipopagamento tp
                                   where p.dataActual BETWEEN :dat1 AND :dat2
								   AND p.associado = a.id 
                                   AND p.tipopagamento=tp.id
                                   AND a.pessoa = pe.id
                                   GROUP BY p.associado, p.tipopagamento
                                   ORDER BY nome,tipos,total ASC");


        $query->setParameters(array('dat1' => $data1, 'dat2' => $data2));

        $saida = $query->getResult();



        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioPagamento($saida, $data1, $data2);
        $declaracao->Output("PlanoDePensoes.pdf", 'I');
    }

    public function comparticipacaotipoSubsidioIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        //die($data2);
        $query = $em->createQuery('SELECT c 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s,
                                   UsokoSIGBundle:Associado ass
                                   where c.subsidio = s.id 
                                   and c.associado = ass.id
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                   ORDER BY c.subsidio,c.associado ASC');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();


        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioSubsidio($saida, $data1, $data2);
        $declaracao->Output("RelatorioSubsidio.pdf", 'I');

        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Personalizado/ComparticipacaoSubsidio/intervalo.html.twig', array('entities' => $saida,
    }

    public function comparticipacaoQtdAssociadoIntervaloAction($data1, $data2) {

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery('SELECT s.tipo as tipo, count(c.associado) as pessoas 
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:Subsidio s, UsokoSIGBundle:Associado a 
                                   where c.subsidio  = s.id
                                   and  c.associado  = a.id
                                   AND c.dataActual BETWEEN ?1 AND ?2
                                    ');


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();

        die("");
    }

    public function pagamentoSubsidioIntervaloAction(Request $req) {


        $data1 = $req->request->get('dtaini');
        $data2 = $req->request->get('dtafim');

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT distinct(p.nome) as NomeDele,a.nMecanografico as Mec,
                                   s.tipo as tiposub, c.valor as massa,
								   cr.id as codex
                                   FROM UsokoSIGBundle:Comparticipacao c,
                                   UsokoSIGBundle:ComparticipacaoResposta cr,
                                   UsokoSIGBundle:Subsidio s, 
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p
                                   where c.subsidio  = s.id
                                   and  c.associado  = a.id
                                   and cr.resposta = 'A'
                                   and cr.comparticipacao = c.id
                                   and a.pessoa = p.id
                                   and c.estado = 'A'
                                   and cr.data BETWEEN ?1 AND ?2
								   group by a.id
                                   order by NomeDele,tiposub
                                   ");


        $query->setParameter(1, $data1);
        $query->setParameter(2, $data2);
        $saida = $query->getResult();


        $bancoconta = $em->getRepository("UsokoSIGBundle:BancoConta")->findBy(array('tipo' => 'U'));

        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->ordemTransfSubsidio($saida, $data1, $data2, $bancoconta[0]->getNumero());
        $declaracao->Output("ficheiroMensalSubsidio.pdf", 'I');
    }

    public function pagamentoCreditoIntervaloAction(Request $req) {

        $data1 = $req->request->get('dtaini');
        $data2 = $req->request->get('dtafim');

        $diferenca = strtotime($data2) - strtotime($data1);
        $meses = floor($diferenca / (3600 * 24 * 30));

        $Cdata1 = (string) ($data1);
        $Cdata2 = (string) ($data2);

        $d1 = $Cdata1;
        $d2 = $Cdata2;

        $ano1 = substr($Cdata1, 0, 4);
        $mes1 = substr($Cdata1, 5, 2);

        $Cdata1 = $mes1 . "-" . $ano1;

        $ano2 = substr($Cdata2, 0, 4);
        $mes2 = substr($Cdata2, 5, 2);

        $Cdata2 = $mes2 . "-" . $ano2;

        $em = $this->getDoctrine()->getManager();
        $query = $em->createQuery("SELECT DISTINCT cp.dataActual,tc.nome as tcred , p.nome as NomeDele,
                                   bc.numero as Mec, cp.id as codE,
                                   cr.id as codex,cr.valor as massa 
                                   FROM UsokoSIGBundle:CreditoPedido cp,
                                   UsokoSIGBundle:CreditoResposta cr,
                                   UsokoSIGBundle:TipoCredito tc,
                                   UsokoSIGBundle:Associado a,
                                   UsokoSIGBundle:Pessoa p,
								   UsokoSIGBundle:Pagamento Pa,
								   UsokoSIGBundle:BancoConta bc,
								   UsokoSIGBundle:Tipopagamento TP
                                   WHERE cr.creditoPedido = cp.id
                                   AND cp.tipoCredito=tc.id
								   AND Pa.tipopagamento = TP.id
								   AND Pa.estado='L'
								   AND a.conta = bc.id
                                   and cr.resposta =?1
                                   and a.pessoa = p.id
                                   and  cp.associado  = a.id
                                   and cp.dataActual BETWEEN ?2 AND ?3
								   
								   ORDER BY tc.nome,NomeDele
                                   ");

        $query->setParameter(1, 'A');
        $query->setParameter(2, $data1);
        $query->setParameter(3, $data2);
        //$query->setParameter(4, $Cdata1);
        //$query->setParameter(5, $Cdata2);
        $saida = $query->getResult();

        $bancoconta = $em->getRepository("UsokoSIGBundle:BancoConta")->findBy(array('tipo' => 'U'));


        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->ordemTransfCredito($saida, $data1, $data2, $bancoconta[0]->getNumero());
        $declaracao->Output("ordemTransfCredito.pdf", 'I');
    }

    public function confirmarPagamentoCreditoBancoAction(Request $req) {
        $id = $req->request->get('codigo');

        $em = $this->getDoctrine()->getManager();
        $creditoResposta = $em->getRepository('UsokoSIGBundle:CreditoResposta')->findBy(array('id' => $id, 'resposta' => 'P'));

        if (!$creditoResposta) {
            $resposta = 'nao';
            return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoCredito.html.twig', array(
                        'resposta' => $resposta
            ));
        }
        if ($creditoResposta) {
            $resposta = 'sim';
            $creditoResposta->setResposta('AP');
            $em->flush();

            return $this->render('UsokoSIGBundle:Pagamento:confirmarPagamentoCredito.html.twig', array(
                        'resposta' => $resposta
            ));
        }
    }

    public function confirmarPagamentoDesvinculadosBancoAction(Request $request) {

        if (!$request->isXmlHttpRequest()) {
            throw new NotFoundHttpException();
        }

        $id = $request->query->get('a');
        $em = $this->getDoctrine()->getManager();

        $ppDesvinc = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->find($id);
        $ppDesvVerifica = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->findOneBy(array('id' => $id, 'pago' => 'N'));
        $ppDesvVerifica2 = $em->getRepository('UsokoSIGBundle:PpDesvinculacao')->findOneBy(array('id' => $id, 'pago' => 'S'));

        $result = array();


        if (!$ppDesvinc) {
            $result['rs'] = 0;
            $result['dado'] = 0;
            return new JsonResponse($result);
        } else if ($ppDesvVerifica2) {
            $result['rs'] = 3;
            $result['dado'] = 3;
            return new JsonResponse($result);
        } else if ($ppDesvinc and $ppDesvVerifica) {
            $result['rs'] = 1;
            $ppDesvinc->setPago('S');
            $ppDesvinc->setDatapag(new \DateTime('now'));
            $result['nome'] = json_encode($ppDesvinc->getPlanoPensao()->getAssociado()->getPessoa()->getNome());
            $em->flush();
            return new JsonResponse($result);
        }
    }

    public function associadoFichaAction($id) {
//Desincriptar o Id do Associado
         $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Associado entity.');
        }
        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioAssociadoFicha($entity);
        $declaracao->Output("associadoficha.pdf", 'I');
    }

    public function associadoFichaActionTeste($id) {
//Desincriptar o Id do Associado
        $id = $this->get('nzo_url_encryptor')->decrypt($id);


        $em = $this->getDoctrine()->getManager();
        /* $query = $em->createQuery("SELECT p.nome as nomes,tc.nome, a.nMecanografico as nMec,
          cp.dataActual as actual, cp.valor as solic
          FROM UsokoSIGBundle:CreditoPedido cp,
          UsokoSIGBundle:Associado a,
          UsokoSIGBundle:Pessoa p,
          UsokoSIGBundle:TipoCredito tc
          where cp.associado = a.id
          and cp.tipoCredito = tc.id
          and a.id = p.id
          and cp.estado = :state
          order by tc.nome,nomes,cp.dataActual
          ")->setParameters(array('state' => 'A'));

          $saida = $query->getResult();

         */
        //$html = $this->renderView('UsokoSIGBundle:PDF:Relatorio/Credito/associadoCredito.html.twig', array('entities' => $saida));

        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this, 1, 1, 1);
        $declaracao->corpoRelatorioAssociadoFicha($id);
        $declaracao->Output("associadoficha.pdf", 'I');
    }

}
