<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Quota;
use Usoko\SIGBundle\Form\QuotaType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Quota controller.
 *
 */
class QuotaController extends Controller {

    /**
     * Lists all Quota entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Quota')->findAll();
        
         $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Quota:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Quota entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Quota();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && \Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Quota", "I", "Registo de Uma Nova Quota");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('quota_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Quota:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Quota entity.
     *
     * @param Quota $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Quota $entity) {
        $form = $this->createForm(new QuotaType(), $entity, array(
            'action' => $this->generateUrl('quota_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Quota entity.
     *
     */
    public function newAction() {
        $entity = new Quota();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Quota:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Quota entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Quota')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Quota entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Quota:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Quota entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Quota')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Quota entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Quota:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Quota entity.
     *
     * @param Quota $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Quota $entity) {
        $form = $this->createForm(new QuotaType(), $entity, array(
            'action' => $this->generateUrl('quota_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Quota entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $entity = $em->getRepository('UsokoSIGBundle:Quota')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Quota entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Quota", "U", "Actualização de Uma Nova Quota");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('quota_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Quota:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Quota entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Quota')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Quota entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Quota", "D", "Remoção de Uma Nova Quota");

            $em->remove($entity);
            $em->flush();

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('quota'));
    }

    /**
     * Creates a form to delete a Quota entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('quota_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
