<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\PlanoPensao;
use Usoko\SIGBundle\Entity\PpAumento;
use Usoko\SIGBundle\Entity\PpDesvinculacao;
use Usoko\SIGBundle\Form\PlanoPensaoType;
use Usoko\SIGBundle\Form\PpAumentoType;
use Usoko\SIGBundle\Form\PpDesvinculacaoType;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\DataGeneral;
use Usoko\SIGBundle\General\UploadGeneral;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Symfony\Component\Form\FormError;
use Usoko\SIGBundle\General\NumeroReal;

/**
 * PlanoPensao controller.
 *
 */
class PlanoPensaoController extends Controller {

    /**
     * Lists all PlanoPensao entities.
     *
     */
    public function indexAction($cod, Request $request) {

        $em = $this->getDoctrine()->getManager();

        if ($cod == 'dsdscs') {
            $estado = 'A'; // ativos
        } elseif ($cod == 'fefdgfg') {
            $estado = 'D'; // desvinculados   
        } elseif ($cod == 'sfsdfg') {
            $estado = 'R';  // reformados
        } else {
            $estado = 'P'; // pendente
        }

        $entities = $em->getRepository('UsokoSIGBundle:PlanoPensao')->findBy(array('estado' => $estado));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:PlanoPensao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
                    'estado' => $estado,
        ));
    }

    /**
     * Creates a new PlanoPensao entity.
     *
     */
    public function createAction(Request $request, $associado) {

        $associadoCR = $associado;
        $associado = CryptGeneral::decrypt($this, $associado);
        $em = $this->getDoctrine()->getManager();
        $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($associado);

        if (!$associado) {
            throw $this->createNotFoundException("Associado Não Encontrado");
        }

        $entity = new PlanoPensao();
        $form = $this->createCreateForm($entity, $associadoCR);
        $form->handleRequest($request);

        $entity->setValor($this->valor($request));
        $valid = true;
//        if ($entity->getValor() >= $associado->getSalario()) {
//            $form->get('valor')->addError(new FormError('Valor não pode ser superior ao salário do Associado...'));
//            $valid = false;
//        }
        // valor abaixo do minimo
        //$tipopagamento = new \Usoko\SIGBundle\Entity\Tipopagamento();
        $tipopagamento = $em->getRepository('UsokoSIGBundle:Tipopagamento')->findByTipo('PP'); // 

        if (isset($tipopagamento[0])) {
            $tipopagamento = $tipopagamento[0];
            $tipopag = $tipopagamento->getValor();
            if ($entity->getValor() < $tipopag) {
                $form->get('valor')->addError(new FormError('Valor mínimo aceite ' . $tipopag));
                $valid = false;
            }
        }

        if ($valid) {
            $associado->setPlanopensao('S');
            $entity->setAssociado($associado);
            $entity->setEstado('A');

            $em->getConnection()->beginTransaction();
            $em->persist($associado);
            $em->persist($entity);
            $em->flush();

            $temp_anexo = $entity->getAnexo();
            $entity->setAnexo(null);
            if ($temp_anexo) {
                $file_name = md5($entity->getId());
                $answer = UploadGeneral::upload($temp_anexo, VarsGeneral::CONS_UPLOAD_PLANOPENSAO_ANEXO, $file_name, false);
                $entity->setAnexo($answer);
            }

            $em->flush();   // update 
            AuditoriaGeneral::auditar($this, $em, $entity, "PlanoPensao", "I", "Registo de Um Novo Plano Pensao");
            $em->getConnection()->commit();

            $id = CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('planopensao_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:PlanoPensao:PP_Aderir.html.twig', array(
                    'entity' => $associado,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a PlanoPensao entity.
     *
     * @param PlanoPensao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(PlanoPensao $entity, $associado) {
        $form = $this->createForm(new PlanoPensaoType(), $entity, array(
            'action' => $this->generateUrl('planopensao_create', array('associado' => $associado)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new PlanoPensao entity.
     *
     */
    public function newAction($associado) {

        $associadoCR = $associado;
        $associado = CryptGeneral::decrypt($this, $associado);
        $em = $this->getDoctrine()->getManager();
        $associado = $em->getRepository('UsokoSIGBundle:Associado')->find($associado);

        if (!$associado) {
            throw $this->createNotFoundException("Associado Não Encontrado");
        }

        $entity = new PlanoPensao();
        $form = $this->createCreateForm($entity, $associadoCR);

        return $this->render('UsokoSIGBundle:PlanoPensao:PP_Aderir.html.twig', array(
                    'entity' => $associado,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a PlanoPensao entity.
     *
     */
    public function showAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PlanoPensao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $espera = DataGeneral::diference($entity->getData());

        $beneficios = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->findBy(array('planoPensao' => $id));
        $entityPpAumento = new PpAumento();
        $ppAumentoForm = $this->createCreateFormPpAumento($entityPpAumento, CryptGeneral::encrypt($this, $id));
        $entityPpDesvinculacao = new PpDesvinculacao();
        $ppDesvinculacaoForm = $this->createCreateFormPpDesvinculacao($entityPpDesvinculacao, CryptGeneral::encrypt($this, $id));

        return $this->render('UsokoSIGBundle:PlanoPensao:PP_Dados.html.twig', array(
                    'pp' => $entity,
                    'espera' => $espera,
                    'entity' => $entity->getAssociado(),
                    'delete_form' => $deleteForm->createView(),
                    'beneficios' => $beneficios,
                    'form_ppAumento' => $ppAumentoForm->createView(),
                    'form_ppDesvinculacao' => $ppDesvinculacaoForm->createView(),
        ));
    }

    public function showAtAction($id) {
        $id = CryptGeneral::decrypt($this, $id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PlanoPensao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $espera = DataGeneral::diference($entity->getData());

        $beneficios = $em->getRepository('UsokoSIGBundle:BeneficioPedido')->findBy(array('planoPensao' => $id));
        $entityPpAumento = new PpAumento();
        $ppAumentoForm = $this->createCreateFormPpAumento($entityPpAumento, CryptGeneral::encrypt($this, $id));
        $entityPpDesvinculacao = new PpDesvinculacao();
        $ppDesvinculacaoForm = $this->createCreateFormPpDesvinculacao($entityPpDesvinculacao, CryptGeneral::encrypt($this, $id));

        return $this->render('UsokoSIGBundle:PlanoPensao:Atendente/PP_Dados.html.twig', array(
                    'pp' => $entity,
                    'espera' => $espera,
                    'entity' => $entity->getAssociado(),
                    'delete_form' => $deleteForm->createView(),
                    'beneficios' => $beneficios,
                    'form_ppAumento' => $ppAumentoForm->createView(),
                    'form_ppDesvinculacao' => $ppDesvinculacaoForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing PlanoPensao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = new PlanoPensao();
        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PlanoPensao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:PlanoPensao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a PlanoPensao entity.
     *
     * @param PlanoPensao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(PlanoPensao $entity) {
        $form = $this->createForm(new PlanoPensaoType(), $entity, array(
            'action' => $this->generateUrl('planopensao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing PlanoPensao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find PlanoPensao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            return $this->redirect($this->generateUrl('planopensao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:PlanoPensao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a PlanoPensao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find PlanoPensao entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('planopensao'));
    }

    /**
     * Creates a form to delete a PlanoPensao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('planopensao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function ppAction($associado) {

        $associadoCR = $associado;
        $associado = CryptGeneral::decrypt($this, $associado);

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->findBy(array('associado' => $associado));

        if (isset($entity[0])) {
            $id = CryptGeneral::encrypt($this, $entity[0]->getId());
            return $this->redirect($this->generateUrl('planopensao_show', array('id' => $id)));
        } else {
            if ($this->get('security.context')->isGranted('ROLE_ADMIN') || $this->get('security.context')->isGranted('ROLE_CONSULTA1')) {
                return $this->render('UsokoSIGBundle:Error:notPlanoPensao.html.twig', array());
            }

            return $this->redirect($this->generateUrl('planopensao_new', array('associado' => $associadoCR)));
        }
    }

    public function ppAtAction($associado) {

        $associadoCR = $associado;
        $associado = CryptGeneral::decrypt($this, $associado);

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:PlanoPensao')->findBy(array('associado' => $associado));

        if (isset($entity[0])) {
            $id = CryptGeneral::encrypt($this, $entity[0]->getId());
            return $this->redirect($this->generateUrl('planopensao_showAt', array('id' => $id)));
        } else {
            if ($this->get('security.context')->isGranted('ROLE_ADMIN') || $this->get('security.context')->isGranted('ROLE_CONSULTA1')) {
                return $this->render('UsokoSIGBundle:Error:notPlanoPensao.html.twig', array());
            }

            return $this->redirect($this->generateUrl('planopensao_new', array('associado' => $associadoCR)));
        }
    }

// Criação de Fomulários 
    public function createCreateFormPpAumento(PpAumento $entity, $planoPensao) {
        $form = $this->createForm(new PpAumentoType(), $entity, array(
            'action' => $this->generateUrl('ppaumento_novo', array('planoPensao' => $planoPensao)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('reset', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    public function createCreateFormPpDesvinculacao(PpDesvinculacao $entity, $planoPensao) {
        $form = $this->createForm(new PpDesvinculacaoType(), $entity, array(
            'action' => $this->generateUrl('ppdesvincular_novo', array('planoPensao' => $planoPensao)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('reset', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    public function aumentarAction(Request $request, $planoPensao) {
        $em = $this->getDoctrine()->getManager();
        $planoPensao = $this->get('nzo_url_encryptor')->decrypt($planoPensao);
        $planoPensao = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($planoPensao);

        if (!$planoPensao) {
            throw $this->createNotFoundException('Entidade não encontrada.');
        }

        $entity = new PpAumento();
        $form = $this->createCreateFormPpAumento($entity, $planoPensao);
        $form->handleRequest($request);

        $entity->setValorAntes($planoPensao->getValor()); // Recuperação do Valor anterior 
        $entity->setData(DataGeneral::tempoGeral());
        $planoPensao->setValor($entity->getValorPos()); // Actualização  do Valor anterior no plano de pensão 
        $temp_anexo = $entity->getAnexo();
        $entity->setAnexo(null);

        if ($form->isValid() && Validacao::validar($this, $entity)) {

            $em->persist($entity);
            $em->persist($planoPensao);
            if ($temp_anexo) {
                $file_name = md5($entity->getId());
                $answer = UploadGeneral::upload($temp_anexo, VarsGeneral::CONS_UPLOAD_PLANOPENSAO_ANEXO, $file_name, false);
                $entity->setAnexo($answer);
            }
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpAumento", "I", "Registo de um novo aumento.");
            return $this->redirect($this->generateUrl('planopensao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($planoPensao->getId()))));
        }

        return $this->showAction($this->get('nzo_url_encryptor')->encrypt($planoPensao->getId()));
    }

    public function desvincularAction(Request $request, $planoPensao) {

        $em = $this->getDoctrine()->getManager();
        $planoPensao = $this->get('nzo_url_encryptor')->decrypt($planoPensao);
        $planoPensao = $em->getRepository('UsokoSIGBundle:PlanoPensao')->find($planoPensao);
        if (!$planoPensao) {
            throw $this->createNotFoundException('Entidade não encontrada.');
        }
        if ($panloPensao->getEstado() == 'D') {

            throw $this->createNotFoundException('Associado já desvinculado.');
        }
        $entity = new PpDesvinculacao();
        $form = $this->createCreateFormPpDesvinculacao($entity, $planoPensao);
        $form->handleRequest($request);



        $entity->setData(DataGeneral::tempoGeral());
        $tempoBeneficio = DataGeneral::diference($planoPensao->getData(), null, 'y');
        $desvinculacaoPercentagem = $em->getRepository('UsokoSIGBundle:PpDesvinculacaoPercentagem')->findAll();
        foreach ($desvinculacaoPercentagem as $a) {
            if ($a->getFim() != NULL) {
                if ($a->getInicio() <= $tempoBeneficio && $a->getFim() > $tempoBeneficio) {
                    $percentualTempo = $a->getPercentagem();
                }
            } else {
                if ($a->getInicio() <= $tempoBeneficio) {
                    $percentualTempo = $a->getPercentagem();
                }
            }
        }
        $entity->setPlanoPensao($planoPensao);
        $entity->setPercentagem($percentualTempo);
        $entity->setTempopp(DataGeneral::diference($planoPensao->getData(), null));
        $entity->setValortotalpp($planoPensao->getAssociado()->getId()->getSaldoliquido());
        $entity->setValor((($entity->getValortotalpp() * $percentualTempo) / 100));
        $planoPensao->setEstado('D'); // Actualização  do Estado do Plano de Pensão
        $planoPensao->getAssociado()->setPlasetPlanopensao('N'); // Actualiza o plano de pensão no associado; 
        $temp_anexo = $entity->getAnexo();
        $entity->setAnexo(null);

        if (true) {
            $em->persist($entity);
            $em->persist($planoPensao);
            if ($temp_anexo) {
                $file_name = md5($entity->getId());
                $answer = UploadGeneral::upload($temp_anexo, VarsGeneral::CONS_UPLOAD_PLANOPENSAO_ANEXO, $file_name, false);
                $entity->setAnexo($answer);
            }
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "PpDesvinculacao", "I", "Registo de uma desvinculacao.");
            return $this->redirect($this->generateUrl('planopensao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($planoPensao->getId()))));
        }

        return $this->showAction($this->get('nzo_url_encryptor')->encrypt($planoPensao->getId()));
    }

    private function valor($request) {
        $valor = $request->request->get('usoko_sigbundle_planopensao')['valor'];
        $valor = NumeroReal::converter($valor);
        return $valor;
    }

}
