<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Parametrosimulacao;
use Usoko\SIGBundle\Form\ParametrosimulacaoType;

/**
 * Parametrosimulacao controller.
 *
 */
class ParametrosimulacaoController extends Controller {

    /**
     * Lists all Parametrosimulacao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Parametrosimulacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Parametrosimulacao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Parametrosimulacao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity->setDataCriacao(new \DateTime());

            if ($entity->getEstado() == 'A') {
                if ($this->desactivarParametros()) {
                    $em->persist($entity);
                    $em->flush();
                }
                $entities = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findAll();
                return $this->render('UsokoSIGBundle:Parametrosimulacao:index.html.twig', array('entities' => $entities,));
            } else {
                $em->persist($entity);
                $em->flush();
            }

            return $this->redirect($this->generateUrl('parametrosimulacao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Parametrosimulacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Parametrosimulacao entity.
     *
     * @param Parametrosimulacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Parametrosimulacao $entity) {
        $form = $this->createForm(new ParametrosimulacaoType(), $entity, array(
            'action' => $this->generateUrl('parametrosimulacao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Parametrosimulacao entity.
     *
     */
    public function newAction() {
        $entity = new Parametrosimulacao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Parametrosimulacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Parametrosimulacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Parametrosimulacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Parametrosimulacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Parametrosimulacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Parametrosimulacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Parametrosimulacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Parametrosimulacao entity.
     *
     * @param Parametrosimulacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Parametrosimulacao $entity) {
        $form = $this->createForm(new ParametrosimulacaoType(), $entity, array(
            'action' => $this->generateUrl('parametrosimulacao_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Parametrosimulacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Parametrosimulacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            return $this->redirect($this->generateUrl('parametrosimulacao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))));
        }

        return $this->render('UsokoSIGBundle:Parametrosimulacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Parametrosimulacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Parametrosimulacao entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->indexAction();
        //return $this->redirect($this->generateUrl('parametrosimulacao'));
    }

    /**
     * Creates a form to delete a Parametrosimulacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('parametrosimulacao_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

    private function desactivarParametros() {
        $em = $this->getDoctrine()->getManager();
        $entitys = $em->getRepository('UsokoSIGBundle:Parametrosimulacao')->findAll();
        try {
            foreach ($entitys as $entity) {
                $entity->setEstado('D');
                $em->flush();
            }
            return true;
        } catch (\Doctrine\DBAL\DBALException $e) {
            return false;
        }
    }

}
