<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\General\PDFGeneral;
use Usoko\SIGBundle\General\NasaPdf;
use Symfony\Component\HttpFoundation\Request;

class PDFController extends Controller {

    public function pdfAction() {
        
        $html = $this->renderView('UsokoSIGBundle:PDF:pdf.html.twig', array());
        $pdf = new PDFGeneral($this);
        return $pdf->htmlPARApdf($html);
    }

    public function pdftableAction() {

        $em = $this->getDoctrine()->getManager();

        $sql = ""
                . "SELECT p.nome as Provincia, m.nome as Municipio , e.bairro as Bairro, e.rua as Rua, e.numero as Numero "
                . "FROM UsokoSIGBundle:Endereco e "
                . "JOIN e.provincia p "
                . "JOIN e.municipio m ";

        $query = $em->createQuery($sql);

        $array[PDFGeneral::STYLE][1]    = 'text-align: right;';
        $array[PDFGeneral::ENTITIES] = $query->getResult();
        $array[PDFGeneral::TITULO] = 'Titulo Da Pagina Lista de k';

        $pdf = new PDFGeneral($this);
        return $pdf->pdfTable($array);
    }
	
	
	 public function declaracaoAction(Request $r) {
        $em = $this->getDoctrine()->getManager();
        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf();

        $declaracao->corpo("sds", "sndmndm");


        $declaracao->SetFillColor(195, 195, 195);
        $declaracao->SetTextColor(0);
        $declaracao->SetDrawColor(0, 0, 0);
        $declaracao->SetLineWidth(0.05);

        /*         * ******************************************** */
       
        /*         * ******************************************** */

        $declaracao->Ln();

        $declaracao->SetFillColor(0, 0, 0);
        $declaracao->SetTextColor(0);
        $declaracao->SetFillColor(255, 255, 255);
        $declaracao->SetTextColor(0);
        $declaracao->SetDrawColor(0, 0, 0);
        $declaracao->SetLineWidth(0.05);
        $declaracao->SetFont('times', '', 12);

        $em = $this->getDoctrine()->getManager();
        $entities = $em->createQuery('SELECT c FROM UsokoSIGBundle:Cargo c')
                ->getResult();


        $fill = 0;
        $cont = 1;
        foreach ($entities as $row) {
            $declaracao->Cell($w[0], 6, $row->getCargo(), 1, 0, 'L', $fill);
            $declaracao->Cell($w[1], 6, 'em', 1, 0, 'L', $fill);
            $declaracao->Cell($w[2], 6, '22-06-2011', 1, 0, 'R', $fill);
            $declaracao->Cell($w[4], 6, rand(10, 19) . '   valores', 1, 0, 'R', $fill);
            $declaracao->Ln();
            $cont++;
        }


        $declaracao->SetFont('times', '', 12);
        $declaracao->Output("DeclaracaoSemNotas.pdf", 'I');
    }
    
    
    public function printAmortizacaoAction(Request $r) {
        $em = $this->getDoctrine()->getManager();
        $this->get('white_october.tcpdf')->create('LANDSCAPE', PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
        $declaracao = new NasaPdf($this,12000,12,1);

        $declaracao->amort(365000,8,1.25);

        $declaracao->showTable(true); 
 
		

        $declaracao->SetFont('times', '', 12);
        $declaracao->Output("DeclaracaoSemNotas.pdf", 'I');
    }


}
