<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Orgao;
use Usoko\SIGBundle\Form\OrgaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;

/**
 * Orgao controller.
 *
 */
class OrgaoController extends Controller {

    /**
     * Lists all Orgao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Orgao')->findBy(array(), array('nome' => 'ASC'));

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Orgao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Orgao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Orgao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid($this) && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Orgao", "I", "Registo de Um Novo Orgão");
            $em->getConnection()->commit();

            $id = \Usoko\SIGBundle\General\CryptGeneral::encrypt($this, $entity->getId());
            return $this->redirect($this->generateUrl('orgao_show', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Orgao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Orgao entity.
     *
     * @param Orgao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Orgao $entity) {
        $form = $this->createForm(new OrgaoType(), $entity, array(
            'action' => $this->generateUrl('orgao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new Orgao entity.
     *
     */
    public function newAction() {
        $entity = new Orgao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Orgao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Orgao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Orgao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Orgao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Orgao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Orgao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Orgao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Orgao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Orgao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Orgao entity.
     *
     * @param Orgao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Orgao $entity) {
        $form = $this->createForm(new OrgaoType(), $entity, array(
            'action' => $this->generateUrl('orgao_update', array('id' => $id = $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Orgao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Orgao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Orgao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "Orgao", "U", "Actualização de Um Orgão");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('orgao'));
        }

        return $this->render('UsokoSIGBundle:Orgao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Orgao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Orgao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Orgao entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "Orgao", "D", "Remoção de Um Orgão");

            try {
                $em->remove($entity);
                $em->flush();
            } catch (\Doctrine\DBAL\DBALException $e) {
                $em->getConnection()->rollback();
                return $this->render('UsokoSIGBundle:Error:DeleteCascade.html.twig');
            }

            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('orgao'));
    }

    /**
     * Creates a form to delete a Orgao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        $id = $this->get('nzo_url_encryptor')->encrypt($id);
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('orgao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
