<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Justificacao;
use Usoko\SIGBundle\Form\JustificacaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;

/**
 * Justificacao controller.
 *
 */
class JustificacaoController extends Controller {

    /**
     * Lists all Justificacao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Justificacao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Justificacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Justificacao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Justificacao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Justificacao", "I", "Registo de Uma Justificação");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('justificacao_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:Justificacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Justificacao entity.
     *
     * @param Justificacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Justificacao $entity) {
        $form = $this->createForm(new JustificacaoType(), $entity, array(
            'action' => $this->generateUrl('justificacao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));
        return $form;
    }

    /**
     * Displays a form to create a new Justificacao entity.
     *
     */
    public function newAction() {
        $entity = new Justificacao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Justificacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Justificacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Justificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Justificacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Justificacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Justificacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:Justificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Justificacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Justificacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Justificacao entity.
     *
     * @param Justificacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Justificacao $entity) {
        $form = $this->createForm(new JustificacaoType(), $entity, array(
            'action' => $this->generateUrl('justificacao_show', array('id' => $id = $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing Justificacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Justificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Justificacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "Justificacao", "U", "Actualização de Uma Justificação");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('justificacao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Justificacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Justificacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Justificacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Justificacao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "Justificacao", "D", "Remoção de Uma Justificação");

            $em->remove($entity);
            $em->flush();
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('justificacao'));
    }

    /**
     * Creates a form to delete a Justificacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('justificacao_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
