<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\FonteRendimento;
use Usoko\SIGBundle\Form\FonteRendimentoType;
use Usoko\SIGBundle\General\Validacao;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * FonteRendimento controller.
 *
 */
class FonteRendimentoController extends Controller {

    /**
     * Lists all FonteRendimento entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:FonteRendimento')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:FonteRendimento:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new FonteRendimento entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new FonteRendimento();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "FonteRendimento", "I", "Registo de Uma Nova Fonte de Rendimento");
            return $this->redirect($this->generateUrl('fonterendimento_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:FonteRendimento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a FonteRendimento entity.
     *
     * @param FonteRendimento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(FonteRendimento $entity) {
        $form = $this->createForm(new FonteRendimentoType(), $entity, array(
            'action' => $this->generateUrl('fonterendimento_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));
        $form->add('limpar', 'reset', array('label' => 'Limpar'));

        return $form;
    }

    /**
     * Displays a form to create a new FonteRendimento entity.
     *
     */
    public function newAction() {
        $entity = new FonteRendimento();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:FonteRendimento:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a FonteRendimento entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:FonteRendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find FonteRendimento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:FonteRendimento:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing FonteRendimento entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $entity = $em->getRepository('UsokoSIGBundle:FonteRendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find FonteRendimento entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:FonteRendimento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a FonteRendimento entity.
     *
     * @param FonteRendimento $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(FonteRendimento $entity) {
        $form = $this->createForm(new FonteRendimentoType(), $entity, array(
            'action' => $this->generateUrl('fonterendimento_update', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Actualizar'));

        return $form;
    }

    /**
     * Edits an existing FonteRendimento entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:FonteRendimento')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find FonteRendimento entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "FonteRendimento", "U", "Actualização de Uma Nova Fonte de Rendimento");
            return $this->redirect($this->generateUrl('fonterendimento_show', array('id' => $this->get('nzo_url_encryptor')->encrypt($entity->getId()))));
        }

        return $this->render('UsokoSIGBundle:FonteRendimento:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a FonteRendimento entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);
        $id = $this->get('nzo_url_encryptor')->decrypt($id);
        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:FonteRendimento')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find FonteRendimento entity.');
            }
            AuditoriaGeneral::auditar($this, $em, $entity, "FonteRendimento", "D", "Remoção de Uma Fonte de Rendimento");
            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('fonterendimento'));
    }

    /**
     * Creates a form to delete a FonteRendimento entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('fonterendimento_delete', array('id' => $this->get('nzo_url_encryptor')->encrypt($id))))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Eliminar'))
                        ->getForm()
        ;
    }

}
