<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\Documentoidentificacao;
use Usoko\SIGBundle\Form\DocumentoidentificacaoType;
use Usoko\SIGBundle\General\AuditoriaGeneral;

/**
 * Documentoidentificacao controller.
 *
 */
class DocumentoidentificacaoController extends Controller {

    /**
     * Lists all Documentoidentificacao entities.
     *
     */
    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:Documentoidentificacao:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    /**
     * Creates a new Documentoidentificacao entity.
     *
     */
    public function createAction(Request $request) {
        $entity = new Documentoidentificacao();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid() && Validacao::validar($this, $entity)) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $em->persist($entity);
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "DocumentoIdentificacao", "I", "Registo de Um Novo Documento de Identificação");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('documentoidentificacao_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:Documentoidentificacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a Documentoidentificacao entity.
     *
     * @param Documentoidentificacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createCreateForm(Documentoidentificacao $entity) {
        $form = $this->createForm(new DocumentoidentificacaoType(), $entity, array(
            'action' => $this->generateUrl('documentoidentificacao_create'),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new Documentoidentificacao entity.
     *
     */
    public function newAction() {
        $entity = new Documentoidentificacao();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:Documentoidentificacao:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a Documentoidentificacao entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Documentoidentificacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Documentoidentificacao:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing Documentoidentificacao entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Documentoidentificacao entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:Documentoidentificacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a Documentoidentificacao entity.
     *
     * @param Documentoidentificacao $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(Documentoidentificacao $entity) {
        $form = $this->createForm(new DocumentoidentificacaoType(), $entity, array(
            'action' => $this->generateUrl('documentoidentificacao_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing Documentoidentificacao entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();
        $entity = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find Documentoidentificacao entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            AuditoriaGeneral::auditar($this, $em, $entity, "DocumentoIdentificacao", "U", "Actualização de Um Documento de Identificação");
            $em->getConnection()->commit();
            return $this->redirect($this->generateUrl('documentoidentificacao_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:Documentoidentificacao:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a Documentoidentificacao entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $em->getConnection()->beginTransaction();
            $entity = $em->getRepository('UsokoSIGBundle:Documentoidentificacao')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find Documentoidentificacao entity.');
            }

            AuditoriaGeneral::auditar($this, $em, $entity, "DocumentoIdentificacao", "D", "Remoção de Um Documento de Identificação");

            $em->remove($entity);
            $em->flush();
            $em->getConnection()->commit();
        }

        return $this->redirect($this->generateUrl('documentoidentificacao'));
    }

    /**
     * Creates a form to delete a Documentoidentificacao entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('documentoidentificacao_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

}
