<?php

namespace Usoko\SIGBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Usoko\SIGBundle\Entity\CreditoResposta;
use Usoko\SIGBundle\Form\CreditoRespostaType;
use Usoko\SIGBundle\Form\CreditoRespostaBType;
use Usoko\SIGBundle\General\CryptGeneral;
use Usoko\SIGBundle\General\VarsGeneral;
use Usoko\SIGBundle\General\AuditoriaGeneral;
use Usoko\SIGBundle\General\Validacao;
use Symfony\Component\Form\FormError;

/**
 * CreditoResposta controller.
 *
 */
class CreditoRespostaController extends Controller {

    public function indexAction(Request $request) {
        $em = $this->getDoctrine()->getManager();

        $entities = $em->getRepository('UsokoSIGBundle:CreditoResposta')->findAll();

        $limit_page = 10;
        $paginator = $this->get('knp_paginator');
        $pagination = $paginator->paginate(
                $entities, $request->query->getInt('page', 1), $limit_page
        );

        return $this->render('UsokoSIGBundle:CreditoResposta:index.html.twig', array(
                    'pagination' => $pagination,
                    'page' => $request->query->getInt('page', 1),
                    'limit_page' => $limit_page,
        ));
    }

    public function createAction(Request $request, $pedido, $op) {

        $em = $this->getDoctrine()->getManager();
        $em->getConnection()->beginTransaction();

        $pedidoCR = $pedido;
        $pedido = $this->get('nzo_url_encryptor')->decrypt($pedido);
        $pedido = $em->getRepository('UsokoSIGBundle:CreditoPedido')->find($pedido);

        $entity = new CreditoResposta();
        if (!$pedido) {
            throw $this->createNotFoundException('Unable to find Credito Pedido entity.');
        }

        if ($op == 'aprove') {
            $form = $this->createCreateForm($entity, $pedidoCR, $this);
            $form->handleRequest($request);

            $ano = date('Y');
            $plafound = new \Usoko\SIGBundle\Entity\CreditoPlafond();
            $plafound = $em->getRepository('UsokoSIGBundle:CreditoPlafond')->findBy(array('ano' => $ano));
            $go = true;
            if (isset($plafound[0])) {
                $plafound = $plafound[0];
                if (($plafound->getValorconcedido() + $entity->getValor()) > $plafound->getValorlimite()) {
                    $form->get('valor')->addError(new FormError('Excedeu o Limite de Crédito Anual'));
                    $go = false;
                }
            } else {
                return $this->render('UsokoSIGBundle:Error:CreditoConfig.html.twig');
            }

            $valorpagar = ($entity->getValor() + ($entity->getValor() * $plafound->getTaxajuros()) / 100);
            $valorMensal = $valorpagar / $entity->getTempoAmortizacao();

            $entity->setValorMensal($valorMensal);
            $entity->setValorpagar($valorpagar);

            // Somar no plafound
            if ($go) {
                $total = $plafound->getValorconcedido() + $entity->getValor();
                $plafound->setValorconcedido($total);
            }

            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_APROVADO;
            $passa = false;
        } elseif ($op == 'deny') {
            $passa = true;
            $form = $this->createCreateFormB($entity, $pedidoCR, $this);
            $form->handleRequest($request);
            $tipo = VarsGeneral::CONS_COMP_RESPOSTA_REPROVADO;
        }

        $pedido->setEstado($tipo);
        $entity->setResposta($tipo);
        $entity->setData(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());
        $entity->setCreditoPedido($pedido);

        $associado = CryptGeneral::encrypt($this, $pedido->getAssociado()->getId());

        //if (\Usoko\SIGBundle\General\Validacao::validar($this, $entity)) {
        if ($passa || ($go && Validacao::validar($this, $entity))) {

            $em->persist($pedido);
            $em->persist($entity);
            $em->flush();
            AuditoriaGeneral::auditar($this, $em, $entity, "CreditoResposta", "I", "Registo de Uma Credito Resposta");
            $em->getConnection()->commit();

            return $this->redirect($this->generateUrl('myCreditoPedido_AS', array('id' => $associado, 'play' => '22')));
        }
        return $this->render('UsokoSIGBundle:CreditoResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    public function createsAction(Request $request) {
        $entity = new CreditoResposta();
        $form = $this->createCreateForm($entity);
        $form->handleRequest($request);

        if ($form->isValid()) {
            die;
            $em = $this->getDoctrine()->getManager();
            $em->persist($entity);
            $em->flush();

            return $this->redirect($this->generateUrl('creditoresposta_show', array('id' => $entity->getId())));
        }

        return $this->render('UsokoSIGBundle:CreditoResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Creates a form to create a CreditoResposta entity.
     *
     * @param CreditoResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    public function createCreateForm(CreditoResposta $entity, $pedido, $obj = null, $op = 'aprove') {
        if ($obj != null) {
            $form = $obj->createForm(new CreditoRespostaType(), $entity, array(
                'action' => $obj->generateUrl('creditoresposta_create', array('pedido' => $pedido, 'op' => $op)),
                'method' => 'POST',
            ));
        } else {
            $form = $this->createForm(new CreditoRespostaType(), $entity, array(
                'action' => $obj->generateUrl('creditoresposta_create', array('pedido' => $pedido, 'op' => $op)),
                'method' => 'POST',
            ));
        }

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    public function createCreateFormB(CreditoResposta $entity, $pedido, $obj = null, $op = 'deny') {
        if ($obj == null) {
            $obj = $this;
        }
        $form = $obj->createForm(new CreditoRespostaBType(), $entity, array(
            'action' => $obj->generateUrl('creditoresposta_create', array('pedido' => $pedido, 'op' => $op)),
            'method' => 'POST',
        ));

        $form->add('submit', 'submit', array('label' => 'Registar'));

        return $form;
    }

    /**
     * Displays a form to create a new CreditoResposta entity.
     *
     */
    public function newAction() {
        $entity = new CreditoResposta();
        $form = $this->createCreateForm($entity);

        return $this->render('UsokoSIGBundle:CreditoResposta:new.html.twig', array(
                    'entity' => $entity,
                    'form' => $form->createView(),
        ));
    }

    /**
     * Finds and displays a CreditoResposta entity.
     *
     */
    public function showAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:CreditoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoResposta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:CreditoResposta:show.html.twig', array(
                    'entity' => $entity,
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Displays a form to edit an existing CreditoResposta entity.
     *
     */
    public function editAction($id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:CreditoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoResposta entity.');
        }

        $editForm = $this->createEditForm($entity);
        $deleteForm = $this->createDeleteForm($id);

        return $this->render('UsokoSIGBundle:CreditoResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Creates a form to edit a CreditoResposta entity.
     *
     * @param CreditoResposta $entity The entity
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createEditForm(CreditoResposta $entity) {
        $form = $this->createForm(new CreditoRespostaType(), $entity, array(
            'action' => $this->generateUrl('creditoresposta_update', array('id' => $entity->getId())),
            'method' => 'PUT',
        ));

        $form->add('submit', 'submit', array('label' => 'Update'));

        return $form;
    }

    /**
     * Edits an existing CreditoResposta entity.
     *
     */
    public function updateAction(Request $request, $id) {
        $em = $this->getDoctrine()->getManager();

        $entity = $em->getRepository('UsokoSIGBundle:CreditoResposta')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Unable to find CreditoResposta entity.');
        }

        $deleteForm = $this->createDeleteForm($id);
        $editForm = $this->createEditForm($entity);
        $editForm->handleRequest($request);

        if ($editForm->isValid()) {
            $em->flush();

            return $this->redirect($this->generateUrl('creditoresposta_edit', array('id' => $id)));
        }

        return $this->render('UsokoSIGBundle:CreditoResposta:edit.html.twig', array(
                    'entity' => $entity,
                    'edit_form' => $editForm->createView(),
                    'delete_form' => $deleteForm->createView(),
        ));
    }

    /**
     * Deletes a CreditoResposta entity.
     *
     */
    public function deleteAction(Request $request, $id) {
        $form = $this->createDeleteForm($id);
        $form->handleRequest($request);

        if ($form->isValid()) {
            $em = $this->getDoctrine()->getManager();
            $entity = $em->getRepository('UsokoSIGBundle:CreditoResposta')->find($id);

            if (!$entity) {
                throw $this->createNotFoundException('Unable to find CreditoResposta entity.');
            }

            $em->remove($entity);
            $em->flush();
        }

        return $this->redirect($this->generateUrl('creditoresposta'));
    }

    /**
     * Creates a form to delete a CreditoResposta entity by id.
     *
     * @param mixed $id The entity id
     *
     * @return \Symfony\Component\Form\Form The form
     */
    private function createDeleteForm($id) {
        return $this->createFormBuilder()
                        ->setAction($this->generateUrl('creditoresposta_delete', array('id' => $id)))
                        ->setMethod('DELETE')
                        ->add('submit', 'submit', array('label' => 'Delete'))
                        ->getForm()
        ;
    }

    public function myCredRespAction($id, $pedido) {

        $id = CryptGeneral::decrypt($this, $id);
        $pedido = CryptGeneral::decrypt($this, $pedido);

        $em = $this->getDoctrine()->getManager();
        $entity = $em->getRepository('UsokoSIGBundle:Associado')->find($id);

        if (!$entity) {
            throw $this->createNotFoundException('Associado Não Encontrado .');
        }

        $resposta = $em->getRepository('UsokoSIGBundle:CreditoResposta')->findOneBy(array('creditoPedido' => $pedido));

        if (!$resposta) {
            throw $this->createNotFoundException(' Pedido de Credito Não encontrado.');
        }

        return $this->render('UsokoSIGBundle:CreditoResposta:PA_DadosCredRest.html.twig', array(
                    'entity' => $entity,
                    'resposta' => $resposta,
        ));
    }

}
